/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.login;

import de.riwagis.util.Support;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.security.encryption.DESCryptUtils;
import de.riwagis.webgiscli.WebGisClient;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.login.LoginCredentials;
import de.riwagis.webgiscli.login.LoginInfo;
import de.riwagis.webgiscli.login.ServerInfo;
import java.security.GeneralSecurityException;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginCredentialsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LoginCredentialsUtils.class);
    public static final String HTTPSERVERNAME = "http-server-name";
    public static final String HTTPLOGINNAME = "http-login-name";
    public static final String HTTPLOGINPWD = "http-login-pwd";
    public static final String HTTPLOGINADMINPWD = "http-login-adminpwd";
    public static final String HTTPLOGINMACHINEKEY = "http-login-machinekey";

    public static final String buildAttributeName(String name, String suffix) {
        if (StringUtils.isBlank((String)suffix)) {
            return name;
        }
        return String.format("%s-%s", name, suffix);
    }

    public static void handleLoginCredentials(Whiteboard whiteBoard, LoginInfo loginInfo) throws GeneralSecurityException {
        ServerInfo si = loginInfo.getServerInfo();
        String serverData = StringUtils.isBlank((String)si.getServerName()) ? si.getServer() + si.getURI() : si.getServerName();
        whiteBoard.setAttribute(LoginCredentialsUtils.buildAttributeName(HTTPSERVERNAME, LoginCredentialsUtils.determineDefaultSuffix()), (Object)serverData);
        LoginCredentials creds = loginInfo.getLoginCredentials();
        if (loginInfo.isStoreLogin()) {
            LoginCredentialsUtils.storeLoginCredentials(whiteBoard, LoginCredentialsUtils.determineDefaultSuffix(), creds);
            WebGisContext.getInstance().writePermWhiteboard();
        } else {
            LoginCredentialsUtils.removeLoginCredentials(whiteBoard, LoginCredentialsUtils.determineDefaultSuffix());
            WebGisContext.getInstance().writePermWhiteboard();
        }
    }

    public static void storeLoginCredentials(Whiteboard whiteBoard, String suffix, LoginCredentials loginCredentials) throws GeneralSecurityException {
        byte[] encPwd = LoginCredentialsUtils.encryptDefault(loginCredentials.getEncryptedPassword());
        whiteBoard.setAttribute(LoginCredentialsUtils.buildAttributeName(HTTPLOGINNAME, suffix), (Object)loginCredentials.getUsername());
        whiteBoard.setAttribute(LoginCredentialsUtils.buildAttributeName(HTTPLOGINPWD, suffix), (Object)encPwd);
    }

    public static void removeLoginCredentials(Whiteboard whiteBoard, String suffix) {
        whiteBoard.remove(LoginCredentialsUtils.buildAttributeName(HTTPLOGINNAME, suffix));
        whiteBoard.remove(LoginCredentialsUtils.buildAttributeName(HTTPLOGINPWD, suffix));
    }

    public static String readServerName(Whiteboard whiteBoard, String suffix) throws SystemException {
        if (whiteBoard.hasAttribute(LoginCredentialsUtils.buildAttributeName(HTTPSERVERNAME, suffix))) {
            return (String)whiteBoard.getAttribute(LoginCredentialsUtils.buildAttributeName(HTTPSERVERNAME, suffix));
        }
        return null;
    }

    public static LoginCredentials readLoginCredentials(Whiteboard whiteBoard, String suffix) throws GeneralSecurityException {
        LoginCredentials storedLc;
        if (whiteBoard.hasAttribute(LoginCredentialsUtils.buildAttributeName(HTTPLOGINNAME, suffix))) {
            byte[] arrEncPwd;
            storedLc = new LoginCredentials();
            storedLc.setUsername((String)whiteBoard.getAttribute(LoginCredentialsUtils.buildAttributeName(HTTPLOGINNAME, suffix)));
            byte[] code = arrEncPwd = (byte[])whiteBoard.getAttribute(LoginCredentialsUtils.buildAttributeName(HTTPLOGINPWD, suffix));
            storedLc.setEncryptedPassword(LoginCredentialsUtils.decryptDefault(code));
        } else {
            storedLc = null;
        }
        return storedLc;
    }

    public static final void removeAdminPwd(Whiteboard whiteBoard, String suffix) {
        whiteBoard.remove(LoginCredentialsUtils.buildAttributeName(HTTPLOGINADMINPWD, suffix));
    }

    public static final String readAdminPwd(Whiteboard whiteBoard, String suffix) throws GeneralSecurityException {
        if (whiteBoard.hasAttribute(LoginCredentialsUtils.buildAttributeName(HTTPLOGINADMINPWD, suffix))) {
            byte[] arrEncAdminPwd = (byte[])whiteBoard.getAttribute(LoginCredentialsUtils.buildAttributeName(HTTPLOGINADMINPWD, suffix));
            return LoginCredentialsUtils.decryptDefault(arrEncAdminPwd);
        }
        return "";
    }

    public static final void storeAdminPassword(Whiteboard whiteBoard, String suffix, String adminPassword) throws GeneralSecurityException {
        if (adminPassword == null) {
            LoginCredentialsUtils.removeAdminPwd(whiteBoard, suffix);
        } else {
            byte[] encAdminPwd = LoginCredentialsUtils.encryptDefault(adminPassword);
            whiteBoard.setAttribute(LoginCredentialsUtils.buildAttributeName(HTTPLOGINADMINPWD, suffix), (Object)encAdminPwd);
        }
    }

    public static final String provideMachineKey(Whiteboard whiteBoard) throws GeneralSecurityException {
        if (!whiteBoard.hasAttribute(HTTPLOGINMACHINEKEY)) {
            whiteBoard.setAttribute(HTTPLOGINMACHINEKEY, (Object)LoginCredentialsUtils.encryptDefault(UUID.randomUUID().toString()));
        }
        return LoginCredentialsUtils.decryptDefault((byte[])whiteBoard.getAttribute(HTTPLOGINMACHINEKEY));
    }

    public static final String determineDefaultSuffix() {
        return WebGisClient.GIS_CONTEXT == null ? "client" : "";
    }

    public static boolean wasPasswordSaved() {
        try {
            return WebGisContext.getInstance().getPermWhiteboard().getAttribute(LoginCredentialsUtils.buildAttributeName(HTTPLOGINPWD, LoginCredentialsUtils.determineDefaultSuffix())) != null;
        }
        catch (Throwable t) {
            LOG.info(String.format("error detecting if password is stored in whiteboard: %s", t.getMessage()), t);
            return false;
        }
    }

    public static String decryptDefault(byte[] encryptedCode) throws GeneralSecurityException {
        return new String(DESCryptUtils.decrypt((byte[])encryptedCode, (byte[])Support.ENC_KEY));
    }

    public static byte[] encryptDefault(String plainCode) throws GeneralSecurityException {
        return DESCryptUtils.encryptFromString((String)plainCode, (byte[])Support.ENC_KEY);
    }

    private LoginCredentialsUtils() {
    }
}

