/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.login;

import de.riwagis.util.Support;
import de.riwagis.util.exception.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginCredentials {
    private static final Logger LOG = LoggerFactory.getLogger(LoginCredentials.class);
    private String username;
    private String encryptedPassword;
    private char[] cleartextPassword;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.cleartextPassword = null;
        this.encryptedPassword = encryptedPassword;
    }

    public char[] getCleartextPassword() {
        if (this.cleartextPassword != null) {
            char[] res = new char[this.cleartextPassword.length];
            System.arraycopy(this.cleartextPassword, 0, res, 0, this.cleartextPassword.length);
            return res;
        }
        return null;
    }

    public void setCleartextPassword(char[] cleartextPassword) {
        if (cleartextPassword != null) {
            this.cleartextPassword = new char[cleartextPassword.length];
            System.arraycopy(cleartextPassword, 0, this.cleartextPassword, 0, cleartextPassword.length);
            try {
                this.encryptedPassword = Support.encryptOneWay((char[])this.cleartextPassword, (String)"SHA-1");
            }
            catch (SystemException ex) {
                LOG.error(String.format("Error encrypting password: %s", ex.getMessage()), (Throwable)ex);
            }
        } else {
            this.cleartextPassword = null;
        }
    }

    public Object clone() {
        LoginCredentials clonedCred = new LoginCredentials();
        clonedCred.setUsername(this.getUsername());
        clonedCred.setEncryptedPassword(this.getEncryptedPassword());
        clonedCred.setCleartextPassword(this.getCleartextPassword());
        return clonedCred;
    }
}

