/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.interfaces;

import de.riwagis.util.Config;
import de.riwagis.util.gui.ErrorBox;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.interfaces.Opener;
import de.riwagis.webgiscli.interfaces.StringSubstitutorWithDefaults;
import java.awt.Desktop;
import java.awt.Window;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UrlOpener
implements Opener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UrlOpener.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private final String urlTemplate;
    private final BrowseAction browseAction;

    UrlOpener(String urlTemplate) {
        this(urlTemplate, Desktop.getDesktop()::browse);
    }

    UrlOpener(String urlTemplate, BrowseAction browseAction) {
        this.urlTemplate = urlTemplate;
        this.browseAction = browseAction;
    }

    @Override
    public void open(Map<String, String> substitutions) {
        try {
            StringSubstitutorWithDefaults stringSubstitutor = new StringSubstitutorWithDefaults(substitutions::get);
            URI uri = new URI(stringSubstitutor.replace(this.urlTemplate));
            this.browseAction.browse(uri);
        }
        catch (IOException | UncheckedIOException | URISyntaxException e) {
            log.error("Could not open interface URL", (Throwable)e);
            SwingUtilities.invokeLater(() -> ErrorBox.showException((Window)WebGisContext.getInstance().getWebGisClient().getFrame(), (String)i18n.get("common.error"), (String)i18n.get("de.riwagis.webgiscli.interfaces.UrlOpener.error-cannot-open"), (Throwable)e));
        }
    }

    @Override
    public boolean writeDatasetsToFile() {
        return this.urlTemplate.contains("${file}");
    }

    @FunctionalInterface
    public static interface BrowseAction {
        public void browse(URI var1) throws IOException;
    }
}

