/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.interfaces;

import de.riwagis.util.Support;
import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.WebGisContext;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringSubstitutorWithDefaults
extends StringSubstitutor {
    public StringSubstitutorWithDefaults(StringLookup variableResolver) {
        super(StringLookupFactory.INSTANCE.interpolatorStringLookup(Map.of("usr", new UserMDLookup()), arg_0 -> ((StringLookup)variableResolver).lookup(arg_0), true));
        this.setEnableSubstitutionInVariables(true);
    }

    private static class UserMDLookup
    implements StringLookup {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(UserMDLookup.class);
        private static Map<String, Function<Object, String>> postProcessors = Map.of("usr_tera_loginpass", value -> {
            String encryptedPassword = String.valueOf(value);
            if (StringUtils.isBlank((String)encryptedPassword)) {
                log.error("TERA Password was request but not set in user account");
                return "";
            }
            try {
                return Support.decryptToString((byte[])Base64.decodeBase64((String)encryptedPassword), (byte[])Support.ENC_KEY);
            }
            catch (SystemException e) {
                log.error("Could not decrypt TERA password", (Throwable)e);
                return "";
            }
        });

        private UserMDLookup() {
        }

        public String lookup(String key) {
            String safeKey = this.ensureUserPrefix(key);
            Object value = WebGisContext.getInstance().getUserInfo().get(safeKey);
            if (value == null) {
                return null;
            }
            return postProcessors.getOrDefault(safeKey, String::valueOf).apply(value);
        }

        private String ensureUserPrefix(String key) {
            if (!key.startsWith("usr_")) {
                return "usr_" + key;
            }
            return key;
        }
    }
}

