/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.interfaces;

import de.riwagis.webgiscli.interfaces.FeatureAttributeSubstitutor;
import de.riwagis.webgiscli.interfaces.SourceLayer;
import java.util.Objects;
import java.util.Set;

class SourceLayerImpl
implements SourceLayer {
    private final String name;
    private final String dataset;
    private final Set<String> requiredAttributes;

    public SourceLayerImpl(String name, String dataset) {
        Objects.requireNonNull(name, "Layer name has to be defined");
        Objects.requireNonNull(name, "Layer dataset template has to be defined");
        this.name = name;
        this.dataset = dataset;
        this.requiredAttributes = FeatureAttributeSubstitutor.getPlaceholders(dataset);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDataset() {
        return this.dataset;
    }

    @Override
    public Set<String> getRequiredAttributes() {
        return this.requiredAttributes;
    }
}

