/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.interfaces;

import de.riwagis.gis.context.module.interfaces.SelectionExternalCall;
import de.riwagis.util.Config;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.interfaces.FeatureAttributeSubstitutor;
import de.riwagis.webgiscli.interfaces.Opener;
import de.riwagis.webgiscli.interfaces.OpenerFactory;
import de.riwagis.webgiscli.interfaces.SourceLayer;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.opengis.feature.simple.SimpleFeature;

class SelectionExternalCallImpl
implements SelectionExternalCall {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private final String name;
    private final String displayName;
    private final boolean visible;
    private final String delimiter;
    private final int maxAllowedDatasets;
    private final String nullDefault;
    private final int priority;
    private final List<SourceLayer> sourceLayers;
    private final Opener opener;

    public SelectionExternalCallImpl(String name, String displayName, boolean visible, String delimiter, int maxAllowedDatasets, String nullDefault, int priority, List<SourceLayer> sourceLayers, List<String> run, String browse, List<String> fileContent) {
        this(name, displayName, visible, delimiter, maxAllowedDatasets, nullDefault, priority, sourceLayers, OpenerFactory.create(run, browse, fileContent));
    }

    public SelectionExternalCallImpl(String name, String displayName, boolean visible, String delimiter, int maxAllowedDatasets, String nullDefault, int priority, List<SourceLayer> sourceLayers, Opener opener) {
        Objects.requireNonNull(name, "interface call definition is missing an unique name.");
        if (maxAllowedDatasets > 10000) {
            throw new IllegalArgumentException("Call does not allow more than 10000 elements to be exported");
        }
        this.name = name;
        this.displayName = displayName;
        this.visible = visible;
        this.delimiter = delimiter;
        this.maxAllowedDatasets = maxAllowedDatasets;
        this.nullDefault = nullDefault;
        this.priority = priority;
        this.sourceLayers = sourceLayers;
        this.opener = opener;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getMaxAllowedDatasets() {
        return this.maxAllowedDatasets;
    }

    public int getPriority() {
        return this.priority;
    }

    public void openWithSelection(BiFunction<String, Set<String>, Stream<SimpleFeature>> featureProviderForLayer) {
        Frame parentFrame = WebGisContext.getInstance().getWebGisClient().getFrame();
        WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)parentFrame, (String)i18n.get("common.wait"));
        dlgWait.setCancelable(false);
        dlgWait.addWorkToDo(() -> {
            try {
                this.openWithSelectionWork(featureProviderForLayer);
            }
            catch (Exception e) {
                dlgWait.setError(e);
            }
        });
        dlgWait.setVisible(250L);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)parentFrame, (Exception)dlgWait.getError(), this.getClass());
        }
    }

    private void openWithSelectionWork(BiFunction<String, Set<String>, Stream<SimpleFeature>> featureProviderForLayer) throws IOException {
        Frame parentFrame = WebGisContext.getInstance().getWebGisClient().getFrame();
        List<String> datasets = this.retrieveDataset(featureProviderForLayer);
        if (datasets.isEmpty()) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(parentFrame, i18n.get("de.riwagis.webgiscli.interfaces.ExternalCallImpl.no-features-found"), i18n.get("common.warning"), 2));
            return;
        }
        if (datasets.size() > this.maxAllowedDatasets) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(parentFrame, i18n.fmt("de.riwagis.webgiscli.WebGisContext.warning-too-many-datasets", new Object[]{this.maxAllowedDatasets}), i18n.get("common.warning"), 2));
            return;
        }
        String stringifiedDataset = datasets.stream().collect(Collectors.joining(this.delimiter));
        HashMap<String, String> substitutions = new HashMap<String, String>();
        substitutions.put("datasets", stringifiedDataset);
        this.opener.open(substitutions);
    }

    private List<String> retrieveDataset(BiFunction<String, Set<String>, Stream<SimpleFeature>> featureProviderForLayer) {
        FeatureAttributeSubstitutor featureAttributeSubstitutor = new FeatureAttributeSubstitutor(this.nullDefault);
        List<String> datasets = ((Stream)this.sourceLayers.stream().flatMap(sourceLayer -> ((Stream)featureProviderForLayer.apply(sourceLayer.getName(), sourceLayer.getRequiredAttributes())).map(feature -> featureAttributeSubstitutor.replace((SimpleFeature)feature, sourceLayer.getDataset()))).filter(s -> !s.isEmpty()).unordered()).distinct().limit(this.maxAllowedDatasets + 1).collect(Collectors.toList());
        return datasets;
    }

    public void open(Map<String, String> parameters) {
        this.opener.open(parameters);
    }

    public Stream<String> layers() {
        return this.sourceLayers.stream().map(SourceLayer::getName);
    }
}

