/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.interfaces;

import de.riwagis.webgiscli.interfaces.ExecutableOpener;
import de.riwagis.webgiscli.interfaces.FileWriteableOpener;
import de.riwagis.webgiscli.interfaces.Opener;
import de.riwagis.webgiscli.interfaces.UrlOpener;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class OpenerFactory {
    static Opener create(List<String> run, String browse, List<String> fileContent) {
        Opener opener = OpenerFactory.createOpener(run, browse);
        if (opener.writeDatasetsToFile()) {
            return new FileWriteableOpener(opener, fileContent);
        }
        return opener;
    }

    private static Opener createOpener(List<String> run, String browse) throws IllegalArgumentException {
        if (run != null && !run.isEmpty()) {
            return new ExecutableOpener(run);
        }
        if (StringUtils.isNotBlank((CharSequence)browse)) {
            return new UrlOpener(browse);
        }
        throw new IllegalArgumentException("Neither executable nor URL was defined for external call");
    }

    private OpenerFactory() {
    }
}

