/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.interfaces;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.riwagis.gis.context.module.interfaces.ExternalCall;
import de.riwagis.gis.context.module.interfaces.InterfaceConfiguration;
import de.riwagis.util.Config;
import de.riwagis.util.gui.ErrorBox;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.interfaces.ExternalCallHookEvent;
import de.riwagis.webgiscli.interfaces.HookedExternalCall;
import de.riwagis.webgiscli.interfaces.InterfaceConfigurationImpl;
import de.riwagis.webgiscli.interfaces.PlainExternalCall;
import de.riwagis.webgiscli.interfaces.QuickInfoSupplierExternalCallImpl;
import de.riwagis.webgiscli.interfaces.SelectionExternalCallImpl;
import de.riwagis.webgiscli.interfaces.SourceLayer;
import de.riwagis.webgiscli.interfaces.SourceLayerImpl;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonConfigurationReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonConfigurationReader.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private final ObjectMapper objectMapper;

    public JacksonConfigurationReader() {
        InjectableValues.Std defaultValues = new InjectableValues.Std();
        defaultValues.addValue("visibleDefault", (Object)true);
        defaultValues.addValue("delimiterDefault", (Object)",");
        defaultValues.addValue("nullDefault", (Object)"null");
        defaultValues.addValue("priorityDefault", (Object)0);
        defaultValues.addValue("maxAllowedDatasetsDefault", (Object)100);
        defaultValues.addValue("fileContentSelectionDefault", Collections.singletonList("${datasets}"));
        defaultValues.addValue("fileContentDefault", Collections.singletonList(""));
        defaultValues.addValue("externalCallsDefault", Collections.emptyList());
        this.objectMapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setInjectableValues((InjectableValues)defaultValues).addMixIn(InterfaceConfigurationImpl.class, InterfaceConfigurationImplMixin.class).addMixIn(ExternalCall.class, ExternalCallMixin.class).addMixIn(PlainExternalCall.class, PlainExternalCallMixin.class).addMixIn(HookedExternalCall.class, HookedExternalCallMixin.class).addMixIn(SelectionExternalCallImpl.class, SelectionExternalCallMixin.class).addMixIn(QuickInfoSupplierExternalCallImpl.class, QuickInfoSupplierExternalCallMixin.class).addMixIn(SourceLayer.class, SourceLayerMixin.class).addMixIn(SourceLayerImpl.class, SourceLayerImplMixin.class);
    }

    public InterfaceConfiguration readConfigurationFromFiles(List<Path> configFiles) {
        try {
            LinkedHashMap<String, ExternalCall> mergedCalls = new LinkedHashMap<String, ExternalCall>();
            for (Path configFile : Objects.requireNonNull(configFiles, "no config files provided")) {
                InterfaceConfigurationImpl singleConfig;
                try {
                    singleConfig = (InterfaceConfigurationImpl)this.objectMapper.readValue(configFile.toFile(), InterfaceConfigurationImpl.class);
                }
                catch (IOException ioex) {
                    throw new IOException(String.format("unable to read/parse file '%s': %s", configFile.toFile().getAbsolutePath(), ioex.getMessage()), ioex);
                }
                for (ExternalCall call : singleConfig.getExternalCalls()) {
                    ExternalCall previousValue = mergedCalls.putIfAbsent(call.getName(), call);
                    if (previousValue == null) continue;
                    log.debug("action '{0}' from '{1}' not added since it already exists.", (Object)call.getName(), (Object)configFile.toFile().getAbsolutePath());
                }
            }
            return new InterfaceConfigurationImpl(mergedCalls.values());
        }
        catch (IOException e) {
            log.error(String.format("could not load external interface call configuration: %s", e.getMessage()), (Throwable)e);
            ErrorBox.showException(null, (String)i18n.get("common.error"), (String)i18n.get("de.riwagis.webgiscli.interfaces.errorReadingJSONs"), (Throwable)e);
            return new InterfaceConfigurationImpl();
        }
    }

    public static class InterfaceConfigurationImplMixin {
        @JsonCreator
        public InterfaceConfigurationImplMixin(@JacksonInject(value="externalCallsDefault") @JsonProperty(value="externalCalls") Collection<ExternalCall> externalCalls) {
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=SelectionExternalCallImpl.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=PlainExternalCall.class, name="plain"), @JsonSubTypes.Type(value=HookedExternalCall.class, name="hook"), @JsonSubTypes.Type(value=SelectionExternalCallImpl.class, name="selection"), @JsonSubTypes.Type(value=QuickInfoSupplierExternalCallImpl.class, name="quickInfoSupplier")})
    public static class ExternalCallMixin {
    }

    public static class PlainExternalCallMixin {
        @JsonCreator
        public PlainExternalCallMixin(@JsonProperty(value="name") String name, @JsonProperty(value="run") List<String> run, @JsonProperty(value="browse") String browse, @JacksonInject(value="fileContentDefault") @JsonProperty(value="fileContent") List<String> fileContent) {
        }
    }

    public static class HookedExternalCallMixin {
        @JsonCreator
        public HookedExternalCallMixin(@JsonProperty(value="name") String name, @JsonProperty(value="events") Set<ExternalCallHookEvent> events, @JsonProperty(value="run") List<String> run, @JsonProperty(value="browse") String browse, @JacksonInject(value="fileContentDefault") @JsonProperty(value="fileContent") List<String> fileContent) {
        }
    }

    public static class SelectionExternalCallMixin {
        @JsonCreator
        public SelectionExternalCallMixin(@JsonProperty(value="name") String name, @JsonProperty(value="displayName") String displayName, @JacksonInject(value="visibleDefault") @JsonProperty(value="visible") boolean visible, @JacksonInject(value="delimiterDefault") @JsonProperty(value="delimiter") String delimiter, @JacksonInject(value="maxAllowedDatasetsDefault") @JsonProperty(value="maxAllowedDatasets") int maxAllowedDatasets, @JacksonInject(value="nullDefault") @JsonProperty(value="nullDefault") String nullDefault, @JacksonInject(value="priorityDefault") @JsonProperty(value="priority") int priority, @JsonProperty(value="sourceLayers") List<SourceLayer> sourceLayers, @JsonProperty(value="run") List<String> run, @JsonProperty(value="browse") String browse, @JacksonInject(value="fileContentSelectionDefault") @JsonProperty(value="fileContent") List<String> fileContent) {
        }
    }

    public static class QuickInfoSupplierExternalCallMixin {
        @JsonCreator
        public QuickInfoSupplierExternalCallMixin(@JsonProperty(value="name") String name, @JsonProperty(value="sources") Set<String> sources, @JsonProperty(value="run") List<String> run, @JsonProperty(value="browse") String browse, @JacksonInject(value="fileContentDefault") @JsonProperty(value="fileContent") List<String> fileContent) {
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=SourceLayerImpl.class)
    @JsonSubTypes(value={})
    public static class SourceLayerMixin {
    }

    public static class SourceLayerImplMixin {
        @JsonCreator
        public SourceLayerImplMixin(@JsonProperty(value="layerid") String name, @JsonProperty(value="dataset") String dataset) {
        }
    }
}

