/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.interfaces;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceConfigurationFinder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InterfaceConfigurationFinder.class);
    private static final Path ROAMINGDIR = Path.of(System.getenv("APPDATA"), "Riwa GmbH", "wgInterface");
    private static final Path WORKINGDIR = Path.of("", new String[0]);
    private static final Path EXEDIR = Path.of(Objects.requireNonNullElse(System.getProperty("launch4j.exedir"), ""), new String[0]);
    private static final String FILE_PATTERN = "interface.*\\.json";

    public static List<Path> findConfigurations() {
        return InterfaceConfigurationFinder.lookupFiles(FILE_PATTERN);
    }

    private static List<Path> lookupFiles(String filePattern) {
        return InterfaceConfigurationFinder.lookupFiles(filePattern, List.of(ROAMINGDIR, WORKINGDIR, EXEDIR));
    }

    private static List<Path> lookupFiles(String filePattern, List<Path> searchPaths) {
        return searchPaths.stream().flatMap(path -> {
            log.debug("Looking for {0} in {1}...", (Object)filePattern, path);
            if (!Files.exists(path, new LinkOption[0])) {
                log.debug("Configuration folder {0} does not exist. Skipping scan.", path);
                return Stream.empty();
            }
            try {
                return Files.find(path, 1, (file, attr) -> file.getFileName().toString().matches(FILE_PATTERN), new FileVisitOption[0]);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }).distinct().collect(Collectors.toList());
    }

    private InterfaceConfigurationFinder() {
    }
}

