/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.interfaces;

import de.riwagis.util.exception.SystemException;
import de.riwagis.webgiscli.util.ThrowingSupplier;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericInterfaceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericInterfaceService.class);
    private final Runtime runtime;
    private final ThrowingSupplier<String, SystemException> httpBridgeUrlSupplier;
    private final UUID clientID;

    public GenericInterfaceService(Runtime runtime, ThrowingSupplier<String, SystemException> httpBridgeUrlSupplier) {
        this.runtime = runtime;
        this.httpBridgeUrlSupplier = httpBridgeUrlSupplier;
        this.clientID = UUID.randomUUID();
    }

    public void registerGenericInterface() {
        Path interfaceExe = Path.of("interface.exe", new String[0]).toAbsolutePath();
        long pid = ProcessHandle.current().pid();
        String httpBridgeURL = "";
        try {
            httpBridgeURL = this.httpBridgeUrlSupplier.get();
        }
        catch (SystemException sysex) {
            log.warn("client registration (ID: {}, URL: '{}', pid: {}, '{}'): {}", new Object[]{this.clientID, httpBridgeURL, pid, interfaceExe, "failed: unable to retrieve bridge URL"});
            return;
        }
        if (!Files.exists(interfaceExe, new LinkOption[0])) {
            log.warn("client registration (ID: {}, URL: '{}', pid: {}, '{}'): {}", new Object[]{this.clientID, httpBridgeURL, pid, interfaceExe, "failed: interface.exe not found"});
            return;
        }
        try {
            log.info("client registration (ID: {}, URL: '{}', pid: {}, '{}'): {}", new Object[]{this.clientID, httpBridgeURL, pid, interfaceExe, "starting"});
            this.runtime.exec(new String[]{interfaceExe.toString(), "-registerClient", this.clientID.toString(), httpBridgeURL, "" + pid}, null, interfaceExe.getParent().toFile());
            log.info("client registration (ID: '{}', URL: '{}', pid: {}, '{}'): {}", new Object[]{this.clientID, httpBridgeURL, pid, interfaceExe, "registered"});
        }
        catch (IOException e) {
            log.warn("Could not start generic interface executable", (Throwable)e);
        }
    }

    public void deregisterGenericInterface() {
        Path interfaceExe = Path.of("interface.exe", new String[0]).toAbsolutePath();
        if (!Files.exists(interfaceExe, new LinkOption[0])) {
            log.info("Generic Interface executable not found");
            return;
        }
        try {
            log.info("Deregistering generic interface executable");
            long pid = ProcessHandle.current().pid();
            this.runtime.exec(new String[]{interfaceExe.toString(), "-deregisterClient", "" + pid}, null, interfaceExe.getParent().toFile());
        }
        catch (IOException e) {
            log.warn("Could not start generic interface executable", (Throwable)e);
        }
    }

    public UUID getClientID() {
        return this.clientID;
    }
}

