/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.interfaces;

import de.riwagis.webgiscli.interfaces.Opener;
import de.riwagis.webgiscli.interfaces.StringSubstitutorWithDefaults;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;

class FileWriteableOpener
implements Opener {
    private final Opener delegate;
    private final List<String> fileContent;

    public FileWriteableOpener(Opener delegate, List<String> fileContent) {
        this.delegate = delegate;
        this.fileContent = fileContent;
    }

    @Override
    public void open(Map<String, String> substitutions) {
        try {
            StringSubstitutorWithDefaults substitutor = new StringSubstitutorWithDefaults(substitutions::get);
            Path tempFile = Files.createTempFile("exchange", ".txt", new FileAttribute[0]);
            String content = this.fileContent.stream().map(arg_0 -> ((StringSubstitutor)substitutor).replace(arg_0)).collect(Collectors.joining(System.lineSeparator()));
            Files.writeString(tempFile, (CharSequence)content, new OpenOption[0]);
            HashMap<String, String> extendendedSubstitutions = new HashMap<String, String>(substitutions);
            extendendedSubstitutions.put("file", tempFile.toString());
            this.delegate.open(extendendedSubstitutions);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public boolean writeDatasetsToFile() {
        return this.delegate.writeDatasetsToFile();
    }
}

