/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.interfaces;

import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.webgiscli.interfaces.StringSubstitutorWithDefaults;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.text.StringSubstitutor;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureAttributeSubstitutor {
    private static final WKTWriter wktWriter = new WKTWriter();
    private final SimpleFeature[] currentFeature = new SimpleFeature[]{null};
    private final StringSubstitutor stringSubstitutor = new StringSubstitutorWithDefaults(key -> {
        if (this.currentFeature[0].getAttribute(key) instanceof Geometry) {
            return wktWriter.write((Geometry)this.currentFeature[0].getAttribute(key));
        }
        return Objects.toString(FeatureUtil.getAttribute((SimpleFeature)this.currentFeature[0], (String)key), nullDefault);
    });

    public FeatureAttributeSubstitutor(String nullDefault) {
    }

    public static Set<String> getPlaceholders(String dataset) {
        HashSet<String> placeholders = new HashSet<String>();
        StringSubstitutor attributeFinder = new StringSubstitutor(key -> {
            placeholders.add(key);
            return "";
        });
        attributeFinder.replace(dataset);
        return placeholders;
    }

    public String replace(SimpleFeature feature, String template) {
        this.currentFeature[0] = feature;
        return this.stringSubstitutor.replace(template);
    }
}

