/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.interfaces;

import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.gis.context.map.MapContext;
import de.riwagis.gis.context.map.VectorLayerContext;
import de.riwagis.gis.context.module.interfaces.ExternalCall;
import de.riwagis.gis.context.module.interfaces.InterfaceConfiguration;
import de.riwagis.gis.context.module.interfaces.SelectionExternalCall;
import de.riwagis.util.Config;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisConfiguration;
import de.riwagis.webgiscli.interfaces.ExternalCallHookEvent;
import de.riwagis.webgiscli.interfaces.ExternalCallService;
import de.riwagis.webgiscli.interfaces.HookedExternalCall;
import de.riwagis.webgiscli.interfaces.PlainExternalCall;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import lombok.Generated;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalCallServiceImpl
implements ExternalCallService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalCallServiceImpl.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private final Collection<ExternalCall> externalCalls;
    private final Supplier<MapContext> activeMapSupplier;

    public ExternalCallServiceImpl(InterfaceConfiguration configuration, Supplier<MapContext> activeMapSupplier) {
        this.externalCalls = configuration.getExternalCalls();
        this.activeMapSupplier = activeMapSupplier;
    }

    @Override
    public Collection<ExternalCall> getExternalCalls() {
        return this.externalCalls;
    }

    @Override
    public void invokeForFIDs(String action, Collection<String> fids) {
        this.invokeCallOrWarn(SelectionExternalCall.class, action, call -> {
            if (fids.size() > call.getMaxAllowedDatasets()) {
                JOptionPane.showMessageDialog(WebGisConfiguration.getWebGisContext().getWebGisClient().getFrame(), i18n.fmt("de.riwagis.webgiscli.WebGisContext.warning-too-many-datasets", new Object[]{call.getMaxAllowedDatasets()}), i18n.get("common.warning"), 2);
                return;
            }
            call.openWithSelection((layerKey, attributes) -> this.getSimpleFeatureStream((String)layerKey, vlc -> vlc.featuresForFIDs(fids, call.getMaxAllowedDatasets(), attributes)));
        });
    }

    @Override
    public void invokeForAllLayerSelections(String action) {
        this.invokeCallOrWarn(SelectionExternalCall.class, action, call -> call.openWithSelection((layerKey, attributes) -> this.getSimpleFeatureStream((String)layerKey, vlc -> vlc.selectedFeatures(attributes, call.getMaxAllowedDatasets()))));
    }

    @Override
    public void invokePlain(String action, Map<String, String> parameters) {
        this.invokeCallOrWarn(PlainExternalCall.class, action, call -> call.open(parameters));
    }

    @Override
    public boolean invokeForLayerSelection(VectorLayerContext vectorLayerContext) {
        return this.calls(SelectionExternalCall.class).filter(SelectionExternalCall::isVisible).filter(ec -> ec.layers().filter(key -> key.equals(vectorLayerContext.getID())).flatMap(key -> this.getVectorLayerContext((String)key).stream()).anyMatch(VectorLayerContext::hasSelection)).max(Comparator.comparingInt(SelectionExternalCall::getPriority)).map(call -> {
            call.openWithSelection((layerKey, attributes) -> vectorLayerContext.selectedFeatures(attributes, call.getMaxAllowedDatasets()));
            return true;
        }).orElse(false);
    }

    @Override
    public void invokeHook(ExternalCallHookEvent event) {
        log.info("Invoking all registered interface calls for '{}'", (Object)event);
        this.calls(HookedExternalCall.class).filter(call -> call.getEvents().contains((Object)event)).forEach(call -> {
            log.debug("Invoking interface call '{}'", (Object)call.getName());
            call.open(Map.of("event", event.name()));
        });
    }

    @Override
    public Collection<SelectionExternalCall> getUserTriggerableSelectionExternalCalls() {
        return this.calls(SelectionExternalCall.class).filter(SelectionExternalCall::isVisible).collect(Collectors.toList());
    }

    @Override
    public boolean qualifiesSelectionForExternalCall(String action) {
        SelectionExternalCall externalCall = this.calls(SelectionExternalCall.class).filter(call -> action.equalsIgnoreCase(call.getName())).findFirst().orElseThrow();
        try {
            return externalCall.layers().flatMap(key -> this.getVectorLayerContext((String)key).stream()).anyMatch(VectorLayerContext::hasSelection);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Stream<SimpleFeature> getSimpleFeatureStream(String layerKey, Function<VectorLayerContext, Stream<SimpleFeature>> featureStreamer) {
        return this.getVectorLayerContext(layerKey).map(featureStreamer).orElse(Stream.empty());
    }

    private Optional<VectorLayerContext> getVectorLayerContext(String layerKey) {
        LayerContext layerContext;
        try {
            layerContext = this.activeMapSupplier.get().getMapLayer(layerKey);
        }
        catch (Exception e) {
            log.error("Could not retrieve map layer ", (Throwable)e);
            return Optional.empty();
        }
        if (!(layerContext instanceof VectorLayerContext)) {
            log.debug("Layer {} does not exist or is no vector layer context", (Object)layerKey);
            return Optional.empty();
        }
        return Optional.of((VectorLayerContext)layerContext);
    }

    private <T extends ExternalCall> void invokeCallOrWarn(Class<T> clazz, String action, Consumer<T> callAction) {
        this.calls(clazz).filter(call -> action.equalsIgnoreCase(call.getName())).findFirst().ifPresentOrElse(callAction, () -> JOptionPane.showMessageDialog(WebGisConfiguration.getWebGisContext().getWebGisClient().getFrame(), i18n.fmt("de.riwagis.webgiscli.WebGisContext.interface-action-not-found", new Object[]{action}), i18n.get("common.warning"), 2));
    }

    private <T extends ExternalCall> Stream<T> calls(Class<T> clazz) {
        return this.getExternalCalls().stream().filter(c -> clazz.isAssignableFrom(c.getClass())).map(c -> c);
    }
}

