/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.interfaces;

import de.riwagis.util.Config;
import de.riwagis.util.gui.ErrorBox;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.interfaces.Opener;
import de.riwagis.webgiscli.interfaces.StringSubstitutorWithDefaults;
import java.awt.Window;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExecutableOpener
implements Opener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutableOpener.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private final List<String> commandParts;

    public ExecutableOpener(List<String> commandParts) {
        this.commandParts = List.copyOf(commandParts);
    }

    @Override
    public void open(Map<String, String> substitutions) {
        try {
            log.info("Starting interface executable");
            Path interfaceExe = Path.of("interface.exe", new String[0]).toAbsolutePath();
            if (!Files.exists(interfaceExe, new LinkOption[0])) {
                log.error("Generic Interface executable not found");
                return;
            }
            StringSubstitutorWithDefaults stringSubstitutor = new StringSubstitutorWithDefaults(substitutions::get);
            List<String> commandWithFilledPlaceholders = this.commandParts.stream().map(arg_0 -> ((StringSubstitutor)stringSubstitutor).replace(arg_0)).map(s -> this.escapeArgument((String)s)).collect(Collectors.toList());
            commandWithFilledPlaceholders.add(0, interfaceExe.toString());
            commandWithFilledPlaceholders.add(1, "-executeAsync");
            log.debug("Invoking interface call: {}", commandWithFilledPlaceholders);
            new ProcessBuilder(new String[0]).command(commandWithFilledPlaceholders).inheritIO().start().onExit().thenAccept(this::logProcessEnding);
        }
        catch (IOException | UncheckedIOException e) {
            log.error("Could not start generic interface executable", (Throwable)e);
            SwingUtilities.invokeLater(() -> ErrorBox.showException((Window)WebGisContext.getInstance().getWebGisClient().getFrame(), (String)i18n.get("common.error"), (String)i18n.get("de.riwagis.webgiscli.interfaces.ExecutableOpener.error-cannot-start"), (Throwable)e));
        }
    }

    private String escapeArgument(String argument) {
        if (argument.contains("\"") || StringUtils.containsWhitespace((CharSequence)argument)) {
            return "\"" + argument.replace("\"", "\"\"") + "\"";
        }
        return argument;
    }

    @Override
    public boolean writeDatasetsToFile() {
        return this.commandParts.stream().anyMatch(s -> s.contains("${file}"));
    }

    private void logProcessEnding(Process process) {
        int exitValue = process.exitValue();
        long pid = process.pid();
        if (exitValue == 0) {
            log.info("Process {} ended peacefully.", (Object)pid);
        } else {
            log.error("Process {} ended with code {}", (Object)pid, (Object)exitValue);
        }
    }
}

