/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.gui;

import de.riwagis.gis.context.module.MenuContext;
import de.riwagis.gis.context.module.MenuContextComparator;
import de.riwagis.gis.context.module.ModuleContext;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.webgiscli.WebGisContext;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.jdesktop.layout.GroupLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuFrame
extends JFrame {
    private static final Logger LOG = LoggerFactory.getLogger(MenuFrame.class);
    private final WebGisContext wgContext;
    private JMenuBar menBar;
    private JMenu menModules;

    public MenuFrame(WebGisContext _wgContext) {
        super("WebGisClient");
        this.wgContext = _wgContext;
        this.initComponents();
        this.initModMenu();
    }

    private void initModMenu() {
        try {
            ArrayList<MenuContext> lstMenus = new ArrayList<MenuContext>();
            Iterator<ModuleContext> i = this.wgContext.getModules();
            while (i.hasNext()) {
                ModuleContext modContext = i.next();
                for (int menuID : modContext.getMenus()) {
                    MenuContext menContext = modContext.getMenu(menuID);
                    lstMenus.add(menContext);
                }
            }
            Collections.sort(lstMenus, new MenuContextComparator());
            for (MenuContext menCtx : lstMenus) {
                JMenu men = menCtx.buildMenu();
                GUISupport.mergeMenu((JMenu)this.menModules, (JMenu)men, (boolean)true);
            }
        }
        catch (Exception e) {
            LOG.error(String.format("error creating menus: %s", e.getMessage()), (Throwable)e);
            GUISupport.msgbox((Component)this, (String)String.format("Fehler beim Erzeugen der Men\u00fcs:\n'%s'", e.getMessage()), (String)"Men\u00fc Fehler");
        }
    }

    private void initComponents() {
        this.menBar = new JMenuBar();
        this.menModules = new JMenu();
        this.setDefaultCloseOperation(3);
        this.menModules.setMnemonic('M');
        this.menModules.setText("Module");
        this.menBar.add(this.menModules);
        this.setJMenuBar(this.menBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 500, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 39, Short.MAX_VALUE));
        this.pack();
    }
}

