/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.dms;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.riwagis.dms.interfaces.DMSInterfaceImplGenericInterface;
import de.riwagis.gis.context.module.ModuleAppContext;
import de.riwagis.util.Config;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.dms.DmsDatatypeIdBean;
import de.riwagis.webgiscli.dms.DmsDatatypeIdEndpointResponseBean;
import de.riwagis.webgiscli.dms.DmsGetDocumentDatatypeId;
import de.riwagis.webgiscli.dms.DmsGetDocumentMetadata;
import de.riwagis.webgiscli.dms.DmsGetProcessMetadata;
import de.riwagis.webgiscli.dms.DmsGetProcessUUID;
import de.riwagis.webgiscli.dms.DmsGetProcessUUIDResponseBean;
import de.riwagis.webgiscli.dms.DmsMetadataBean;
import de.riwagis.webgiscli.dms.DmsMetadataEndpointResponseBean;
import de.riwagis.webgiscli.dms.DmsResponse;
import de.riwagis.webgiscli.dms.DmsSetProcessUuidBean;
import de.riwagis.webgiscli.dms.EndpointAction;
import de.riwagis.webgiscli.dms.PkValueAndUuidPair;
import de.riwagis.webgiscli.dms.dmsactions.CreateDmsProcessAction;
import de.riwagis.webgiscli.dms.dmsactions.DmsAction;
import de.riwagis.webgiscli.dms.dmsactions.ShowDmsDocumentAction;
import de.riwagis.webgiscli.dms.dmsactions.ShowDmsProcessAction;
import de.riwagis.webgiscli.dms.dmsactions.UploadDmsDocumentAction;
import de.riwagis.webgiscli.service.http.EndpointService;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmsService
implements DMSInterfaceImplGenericInterface.DmsServiceAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmsService.class);
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private static final String ENDPOINT_NAME = "baseDmsMetaData";
    private static final int DEFAULT_DMS_CALL_TIMEOUT = 300;
    private final ModuleAppContext moduleAppContext;
    private final ObjectMapper mapper = new ObjectMapper();
    private final EndpointService<EndpointAction, Map<String, Object>> epService;
    private final Map<UUID, CompletableFuture<DmsResponse>> runningDmsRequests = new ConcurrentSkipListMap<UUID, CompletableFuture<DmsResponse>>();
    private CompletableFuture<Void> activeRequest;

    public DmsService(ModuleAppContext moduleAppContext) {
        this(moduleAppContext, new EndpointService<EndpointAction, Map<String, Object>>(Map.class));
    }

    DmsService(ModuleAppContext moduleAppContext, EndpointService<EndpointAction, Map<String, Object>> epService) {
        this.moduleAppContext = moduleAppContext;
        this.epService = epService;
        DMSInterfaceImplGenericInterface.dmsServiceAdapter = this;
    }

    public synchronized CompletableFuture<Void> createProcess(int moduleKey, int dmsServiceId, Object pkValue, Map<String, String> processMetadata, String datatypeId, Runnable afterCreateAction) {
        try {
            String pDatatypeId;
            Map<String, String> pMetaData;
            if (this.activeRequest != null) {
                boolean result = this.activeRequest.cancel(true);
                log.debug("Canceled running DMS request. Result: {}", (Object)result);
            }
            UUID requestUUID = UUID.randomUUID();
            UUID processID = UUID.randomUUID();
            if (processMetadata == null) {
                DmsMetadataBean metadata = this.getMetadataForProcess(moduleKey, dmsServiceId, pkValue);
                pMetaData = metadata.getProcessMetadata();
                pDatatypeId = metadata.getDatatypeId();
            } else {
                pMetaData = processMetadata;
                pDatatypeId = datatypeId;
            }
            CompletableFuture responseFuture = new CompletableFuture();
            this.runningDmsRequests.put(requestUUID, responseFuture);
            DmsAction createProcessDmsAction = ((CreateDmsProcessAction.CreateDmsProcessActionBuilder)((CreateDmsProcessAction.CreateDmsProcessActionBuilder)((DmsAction.DmsActionBuilder)((CreateDmsProcessAction.CreateDmsProcessActionBuilder)CreateDmsProcessAction.builder().moduleID(Objects.requireNonNullElse(pDatatypeId, pMetaData.get("datatypeID")))).processMetadatas(pMetaData)).requestUUID(requestUUID)).processUUID(processID)).build();
            this.activeRequest = ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> this.executeInterface(createProcessDmsAction)).thenComposeAsync(void_ -> responseFuture)).thenAcceptAsync(dmsResponse -> this.handleProcessResponse((DmsResponse)dmsResponse, moduleKey, dmsServiceId, pkValue, processID, afterCreateAction))).orTimeout(300L, TimeUnit.SECONDS).whenCompleteAsync((void_, throwable) -> this.handleRequestEnding((Throwable)throwable, requestUUID));
            return this.activeRequest;
        }
        catch (SystemException ex) {
            throw new RuntimeException(String.format("could not create process with id '%s' (module %d): %s", pkValue, moduleKey, ex.getMessage()), ex);
        }
    }

    public synchronized CompletableFuture<Void> showProcess(int moduleKey, int dmsServiceId, Object pkValue, String datatypeId, UUID processUUID) {
        try {
            if (this.activeRequest != null) {
                boolean result = this.activeRequest.cancel(true);
                log.debug("Canceled running DMS request. Result: {}", (Object)result);
            }
            UUID requestUUID = UUID.randomUUID();
            UUID zeProcessUUID = processUUID != null ? processUUID : this.getProcessUUID(moduleKey, null, dmsServiceId, pkValue);
            DmsMetadataBean metadata = this.getMetadataForProcess(moduleKey, dmsServiceId, pkValue);
            Map<String, String> processMetadata = metadata.getProcessMetadata();
            CompletableFuture responseFuture = new CompletableFuture();
            this.runningDmsRequests.put(requestUUID, responseFuture);
            DmsAction showDmsProcessAction = ((ShowDmsProcessAction.ShowDmsProcessActionBuilder)((ShowDmsProcessAction.ShowDmsProcessActionBuilder)((ShowDmsProcessAction.ShowDmsProcessActionBuilder)((ShowDmsProcessAction.ShowDmsProcessActionBuilder)ShowDmsProcessAction.builder().moduleID(datatypeId)).requestUUID(requestUUID)).processUUID(processUUID)).processMetadatas(processMetadata)).build();
            this.activeRequest = ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> this.executeInterface(showDmsProcessAction)).thenComposeAsync(void_ -> responseFuture)).thenAcceptAsync(dmsResponse -> this.handleProcessResponse((DmsResponse)dmsResponse, moduleKey, dmsServiceId, pkValue, zeProcessUUID, null))).orTimeout(300L, TimeUnit.SECONDS).whenCompleteAsync((void_, throwable) -> this.handleRequestEnding((Throwable)throwable, requestUUID));
            return this.activeRequest;
        }
        catch (SystemException ex) {
            throw new RuntimeException(String.format("could not show file with id '%s' (module %d): %s", pkValue, moduleKey, ex.getMessage()), ex);
        }
    }

    public synchronized CompletableFuture<UUID> uploadDocument(int moduleKey, Integer fileUploadId, Object pkValueOfProcess, Object pkValueOfDocument, Integer dmsServiceIdOfProcess, File file) {
        try {
            if (this.activeRequest != null) {
                boolean result = this.activeRequest.cancel(true);
                log.debug("Canceled running DMS request. Result: {}", (Object)result);
            }
            UUID existingProcessUUID = this.getProcessUUID(moduleKey, fileUploadId, null, pkValueOfProcess);
            DmsMetadataBean metadata = this.getMetadataForDocument(moduleKey, fileUploadId, pkValueOfProcess, pkValueOfDocument);
            UUID requestUUID = UUID.randomUUID();
            UUID processUUID = Objects.requireNonNullElseGet(existingProcessUUID, UUID::randomUUID);
            UUID documentUUID = UUID.randomUUID();
            boolean createProcess = existingProcessUUID == null;
            Path fileToUpload = file.toPath();
            CompletableFuture responseFuture = new CompletableFuture();
            this.runningDmsRequests.put(requestUUID, responseFuture);
            DmsAction uploadDmsDocumentAction = ((UploadDmsDocumentAction.UploadDmsDocumentActionBuilder)((UploadDmsDocumentAction.UploadDmsDocumentActionBuilder)((UploadDmsDocumentAction.UploadDmsDocumentActionBuilder)((UploadDmsDocumentAction.UploadDmsDocumentActionBuilder)((DmsAction.DmsActionBuilder)((UploadDmsDocumentAction.UploadDmsDocumentActionBuilder)((UploadDmsDocumentAction.UploadDmsDocumentActionBuilder)UploadDmsDocumentAction.builder().moduleID(metadata.getDatatypeId())).documentMetadatas(metadata.getDocumentMetadata())).processMetadatas(metadata.getProcessMetadata())).requestUUID(requestUUID)).processUUID(processUUID)).documentUUID(documentUUID)).filename(fileToUpload)).build();
            return ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> this.executeInterface(uploadDmsDocumentAction)).thenComposeAsync(void_ -> responseFuture)).thenApplyAsync(dmsResponse -> {
                if (dmsResponse.isSuccess()) {
                    log.debug("Uploaded document succesfully");
                    if (createProcess) {
                        UUID newProcessUUID = Objects.requireNonNullElse(dmsResponse.getProcessUUID(), processUUID);
                        log.debug("Updating Process UUID to {}", (Object)newProcessUUID);
                        this.setProcessUUID(moduleKey, dmsServiceIdOfProcess, pkValueOfProcess, newProcessUUID);
                    }
                    return Objects.requireNonNullElse(dmsResponse.getDocumentUUID(), documentUUID);
                }
                log.error("Could not show document: {}", (Object)dmsResponse.getErrorMessage());
                throw new RuntimeException(i18n.fmt("de.riwagis.webgiscli.dms.DmsService.response-failed-error", new Object[]{dmsResponse.getErrorMessage()}));
            })).orTimeout(300L, TimeUnit.SECONDS).whenCompleteAsync((void_, throwable) -> this.handleRequestEnding((Throwable)throwable, requestUUID));
        }
        catch (SystemException ex) {
            throw new RuntimeException(String.format("Could not upload file: %s", ex.getMessage()), ex);
        }
    }

    public synchronized CompletableFuture<Void> showDocument(UUID documentUUID, int moduleKey, int fileUploadId, int dmsServiceId, int dmsServiceIdOfProcess, Object pkValueOfProcess, Object pkValueOfDocument) {
        try {
            if (this.activeRequest != null) {
                boolean result = this.activeRequest.cancel(true);
                log.debug("Canceled running DMS request. Result: {}", (Object)result);
            }
            DmsMetadataBean metadata = this.getMetadataForDocument(moduleKey, fileUploadId, pkValueOfProcess, pkValueOfDocument);
            Map<String, String> processMetadata = metadata.getProcessMetadata();
            DmsDatatypeIdBean datatypeIdBean = this.getDatatypeIdForDocument(moduleKey, fileUploadId, pkValueOfDocument);
            UUID requestUUID = UUID.randomUUID();
            CompletableFuture responseFuture = new CompletableFuture();
            this.runningDmsRequests.put(requestUUID, responseFuture);
            DmsAction dmsAction = ((ShowDmsDocumentAction.ShowDmsDocumentActionBuilder)((ShowDmsDocumentAction.ShowDmsDocumentActionBuilder)((ShowDmsDocumentAction.ShowDmsDocumentActionBuilder)((ShowDmsDocumentAction.ShowDmsDocumentActionBuilder)ShowDmsDocumentAction.builder().moduleID(datatypeIdBean.getDatatypeId())).requestUUID(requestUUID)).documentUUID(documentUUID)).processMetadatas(processMetadata)).build();
            return ((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> this.executeInterface(dmsAction)).thenComposeAsync(void_ -> responseFuture)).thenAcceptAsync(dmsResponse -> {
                if (!dmsResponse.isSuccess()) {
                    log.error("Could not show document: {}", (Object)dmsResponse.getErrorMessage());
                    throw new RuntimeException(i18n.fmt("de.riwagis.webgiscli.dms.DmsService.response-failed-error", new Object[]{dmsResponse.getErrorMessage()}));
                }
                log.debug("Shown document succesfully");
            })).orTimeout(300L, TimeUnit.SECONDS).whenCompleteAsync((void_, throwable) -> this.handleRequestEnding((Throwable)throwable, requestUUID));
        }
        catch (SystemException ex) {
            throw new RuntimeException("Could not show file", ex);
        }
    }

    public void consumeResponse(DmsResponse dmsResponse) {
        log.debug("Consuming DMS response");
        CompletableFuture<DmsResponse> dmsRequest = this.runningDmsRequests.get(dmsResponse.getRequestUUID());
        if (dmsRequest != null) {
            dmsRequest.complete(dmsResponse);
            this.runningDmsRequests.remove(dmsResponse.getRequestUUID());
        } else {
            log.debug("Received DMS response with an unknown ID. Probably from an timeouted or canceled previous request.");
        }
    }

    Map<UUID, CompletableFuture<DmsResponse>> getRunningDmsRequests() {
        return Collections.unmodifiableMap(this.runningDmsRequests);
    }

    public UUID getProcessUUID(int moduleKey, Integer fileUploadId, Integer dmsServiceIdProcess, Object pkValueOfProcess) throws SystemException {
        DmsGetProcessUUID metadata = new DmsGetProcessUUID();
        metadata.setFileUploadId(fileUploadId);
        metadata.setDmsServiceIdProcess(dmsServiceIdProcess);
        metadata.setPkValueProcess(Collections.singletonList(pkValueOfProcess));
        return this.epService.callMethod(WebGisContext.getInstance(), moduleKey, ENDPOINT_NAME, metadata, DmsGetProcessUUIDResponseBean.class).orElseThrow(() -> new SystemException("Endpoint response was empty")).getProcessUuids().get(0).getUuid();
    }

    private DmsMetadataBean getMetadataForDocument(int moduleKey, int fileUploadId, Object pkValueOfProcess, Object pkValueOfDocument) throws SystemException {
        DmsGetDocumentMetadata metadataRequest = new DmsGetDocumentMetadata();
        metadataRequest.setFileUploadId(fileUploadId);
        if (pkValueOfDocument == null) {
            metadataRequest.setPkValueProcess(Collections.singletonList(pkValueOfProcess));
        } else {
            metadataRequest.setPkValueFile(Collections.singletonList(pkValueOfDocument));
        }
        return this.epService.callMethod(WebGisContext.getInstance(), moduleKey, ENDPOINT_NAME, metadataRequest, DmsMetadataEndpointResponseBean.class).orElseThrow(() -> new SystemException("Endpoint response was empty")).getMetadata().get(0);
    }

    private DmsMetadataBean getMetadataForProcess(int moduleKey, int dmsServiceId, Object pkValueOfProcess) throws SystemException {
        DmsGetProcessMetadata metadataRequest = new DmsGetProcessMetadata();
        metadataRequest.setDmsServiceId(dmsServiceId);
        metadataRequest.setPkValueProcess(Collections.singletonList(pkValueOfProcess));
        return this.epService.callMethod(WebGisContext.getInstance(), moduleKey, ENDPOINT_NAME, metadataRequest, DmsMetadataEndpointResponseBean.class).orElseThrow(() -> new SystemException("Endpoint response was empty")).getMetadata().get(0);
    }

    private DmsDatatypeIdBean getDatatypeIdForDocument(int moduleKey, int fileUploadId, Object pkValueOfDocument) throws SystemException {
        DmsGetDocumentDatatypeId metadata = new DmsGetDocumentDatatypeId();
        metadata.setFileUploadId(fileUploadId);
        metadata.setPkValueFile(Collections.singletonList(pkValueOfDocument));
        return this.epService.callMethod(WebGisContext.getInstance(), moduleKey, ENDPOINT_NAME, metadata, DmsDatatypeIdEndpointResponseBean.class).orElseThrow(() -> new SystemException("Endpoint response was empty")).getDatatypeIds().get(0);
    }

    private void handleRequestEnding(Throwable throwable, UUID requestUUID) {
        if (throwable != null) {
            log.error("A DMS request failed.", throwable);
            this.runningDmsRequests.remove(requestUUID);
            throw new RuntimeException(i18n.fmt("de.riwagis.webgiscli.dms.DmsService.request-failed-error", new Object[]{this.getErrorMessage(throwable)}), throwable);
        }
        log.debug("A DMS request successed.");
    }

    private String getErrorMessage(Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null && throwable instanceof TimeoutException) {
            message = "Die DMS-Schnittstelle hat nicht geantwortet.";
        }
        return message;
    }

    private void handleProcessResponse(DmsResponse dmsResponse, int moduleKey, int dmsServiceId, Object pkValue, UUID processUUID, Runnable afterCreateAction) {
        if (dmsResponse.isSuccess()) {
            log.debug("DMS responded success.");
            this.setProcessUUID(moduleKey, dmsServiceId, pkValue, Objects.requireNonNullElse(dmsResponse.getProcessUUID(), processUUID));
            if (afterCreateAction != null) {
                afterCreateAction.run();
            }
        } else {
            log.error("DMS responded error: {}", (Object)dmsResponse.getErrorMessage());
            throw new RuntimeException(i18n.fmt("de.riwagis.webgiscli.dms.DmsService.response-failed-error", new Object[]{dmsResponse.getErrorMessage()}));
        }
    }

    private void executeInterface(DmsAction fileContent) throws UncheckedIOException {
        log.debug("DMS action '{}' for datatypeId '{}'", (Object)fileContent.getAction(), (Object)fileContent.getModuleID());
        try {
            File tmpFile = File.createTempFile("dms", ".txt");
            this.mapper.writeValue(tmpFile, (Object)fileContent);
            this.moduleAppContext.invokeExternalCall("dmsInterfaceApplication", Map.of("dmsConfigurationFile", tmpFile.toString()));
        }
        catch (IOException ioex) {
            throw new UncheckedIOException(ioex);
        }
    }

    private void setProcessUUID(int moduleKey, Integer dmsServiceId, Object pkValue, UUID processUUID) {
        try {
            log.debug("Writing DMS process id.");
            DmsSetProcessUuidBean metadata = new DmsSetProcessUuidBean();
            metadata.setAction("setProcessUuid");
            if (dmsServiceId != null) {
                metadata.setDmsServiceId(dmsServiceId);
            }
            metadata.setUuidForRecord(List.of(new PkValueAndUuidPair(pkValue, processUUID)));
            this.epService.callMethod(WebGisContext.getInstance(), moduleKey, ENDPOINT_NAME, metadata);
        }
        catch (SystemException ex) {
            throw new RuntimeException("Could not set process UUID", ex);
        }
    }
}

