/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli.action;

import de.riwagis.webgiscli.WebGisClient;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GFXAction {
    private static final Logger LOG = LoggerFactory.getLogger(GFXAction.class);
    private static final GeometryFactory GEOMFACTORY = new GeometryFactory();

    public static final void zoomTo(double x, double y, double res) {
        Coordinate coord = new Coordinate(x, y);
        try {
            WebGisClient.GIS_CONTEXT.getMapApp().getActiveMap().zoomGeometry((Geometry)GEOMFACTORY.createPoint(coord), res, null, null);
        }
        catch (Exception ex) {
            LOG.error("Error zooming to coordinate:" + String.valueOf(coord), (Throwable)ex);
        }
    }

    public static final void setMarker(double x, double y, double res) {
        GFXAction.setMarker(x, y);
        GFXAction.zoomTo(x, y, res);
    }

    public static final void setMarker(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        try {
            WebGisClient.GIS_CONTEXT.getMapApp().getActiveMap().setMarker(GEOMFACTORY.createPoint(coord));
        }
        catch (Exception ex) {
            LOG.error("Error zooming to coordinate:" + String.valueOf(coord), (Throwable)ex);
        }
    }

    public static final void zoomToLayer(String layername) {
        try {
            WebGisClient.GIS_CONTEXT.getMapApp().getActiveMap().zoomToLayer(layername);
        }
        catch (Exception ex) {
            LOG.error(String.format("Error zooming to in layer '%s': %s", layername, ex.getMessage()), (Throwable)ex);
        }
    }

    public static final void selectInLayer(String layername, String cql, boolean zoomTo) {
        try {
            WebGisClient.GIS_CONTEXT.getMapApp().getActiveMap().selectInLayer(layername, cql, zoomTo);
        }
        catch (Exception ex) {
            LOG.error(String.format("Error selecting objects in layer '%s' (Selection '%s'): %s", layername, cql, ex.getMessage()), (Throwable)ex);
        }
    }

    public static final void selectInLayer(String layername, String selectionField, String selectionIDs, boolean zoomTo) {
        ArrayList<String> searchTerms = new ArrayList<String>();
        for (String currID : StringUtils.split((String)selectionIDs, (char)'|')) {
            searchTerms.add(String.format("(%s='%s')", selectionField, currID));
        }
        if (!searchTerms.isEmpty()) {
            GFXAction.selectInLayer(layername, StringUtils.join(searchTerms, (String)" OR "), zoomTo);
        }
    }

    private GFXAction() {
    }
}

