/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.security.ArrayTypePermission;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import de.riwagis.geotools.data.riwasrv.RiwaSrvDataStore;
import de.riwagis.gis.context.map.LayerContext;
import de.riwagis.gis.context.map.VectorLayerContext;
import de.riwagis.gis.context.module.DialogContext;
import de.riwagis.gis.context.module.ModuleAppContext;
import de.riwagis.gis.context.module.ModuleContext;
import de.riwagis.gis.context.module.interfaces.InterfaceConfiguration;
import de.riwagis.gis.context.module.interfaces.SelectionExternalCall;
import de.riwagis.gis.context.module.quickinfo.QuickInfoAction;
import de.riwagis.gis.context.module.quickinfo.QuickInfoList;
import de.riwagis.gis.context.module.quickinfo.QuickInfoRequest;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceMData;
import de.riwagis.service.ServiceProvider;
import de.riwagis.service.ServiceRequest;
import de.riwagis.service.StreamProcessor;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.service.registry.ServiceRegistry;
import de.riwagis.service.stream.FileStreamProcessor;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.WhiteboardImpl;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.xstream.GenericFileConverter;
import de.riwagis.webgiscli.WebGisClient;
import de.riwagis.webgiscli.WebGisConfiguration;
import de.riwagis.webgiscli.dms.DmsService;
import de.riwagis.webgiscli.interfaces.ExternalCallHookEvent;
import de.riwagis.webgiscli.interfaces.ExternalCallService;
import de.riwagis.webgiscli.interfaces.ExternalCallServiceDummy;
import de.riwagis.webgiscli.interfaces.ExternalCallServiceImpl;
import de.riwagis.webgiscli.interfaces.InterfaceConfigurationFinder;
import de.riwagis.webgiscli.interfaces.JacksonConfigurationReader;
import de.riwagis.webgiscli.login.ServerInfo;
import de.riwagis.webgiscli.module.WebGisModule;
import de.riwagis.webgiscli.module.dialog.WebGisDialog;
import de.riwagis.webgiscli.quickinfo.QuickInfoService;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebGisContext
implements ModuleAppContext {
    private static final XStream WHITEBOARD_XSTREAM = WebGisContext.createSecuredWhiteboardXStream();
    static WebGisClient WG_CLIENT = null;
    private static final String CLIENT_VERSION;
    private static final int CLIENT_API_LEVEL;
    @Deprecated(forRemoval=true)
    public static final int VERSION_NUMBER;
    private static final Logger LOG;
    public static File WGCLIENT_DIR_OLD;
    private File wgClientSettingFile;
    private Whiteboard permWb;
    private Whiteboard internalWb = null;
    private List<ModuleContext> lstModules = new ArrayList<ModuleContext>();
    private static WebGisContext wgContext;
    private static final Lock lockLoadModule;
    private ExternalCallService externalCallService;
    private List<Path> interfaceConfigurationFiles = Collections.emptyList();
    private final QuickInfoService quickInfoService = new QuickInfoService(this);
    private final DmsService dmsService = new DmsService(this);
    private final List<Runnable> applicationCloseListeners = new ArrayList<Runnable>();

    private WebGisContext() {
        WebGisClient.USERPROFILE.mkdirs();
        this.initializeOrMigrateFolderStructore();
        if (OS.isFamilyWindows() && WebGisClient.GIS_CONTEXT != null) {
            this.interfaceConfigurationFiles = InterfaceConfigurationFinder.findConfigurations();
            InterfaceConfiguration configuration = new JacksonConfigurationReader().readConfigurationFromFiles(this.interfaceConfigurationFiles);
            this.externalCallService = new ExternalCallServiceImpl(configuration, () -> WebGisClient.GIS_CONTEXT.getMapApp().getActiveMap());
        } else {
            this.interfaceConfigurationFiles = List.of();
            this.externalCallService = new ExternalCallServiceDummy();
        }
    }

    private void initializeOrMigrateFolderStructore() {
        block11: {
            if (this.shouldWebGisClientBeMigrated()) {
                try {
                    boolean tmpExists = false;
                    File localAppDirectory = DirectoryService.getInstance().getApplicationDataLocalDirectory();
                    File sharedAppDirectory = DirectoryService.getInstance().getApplicationDataDirectory();
                    File TEMPDIR = new File(localAppDirectory, "temp");
                    if (!TEMPDIR.exists()) {
                        tmpExists = TEMPDIR.mkdirs();
                    }
                    if (tmpExists) {
                        File[] settingFiles;
                        File[] workbenchFiles;
                        File[] files;
                        File newJumpDir;
                        File jumpDir;
                        File newProxyDir;
                        FileUtils.copyDirectory((File)WGCLIENT_DIR_OLD, (File)new File(TEMPDIR, ProjectType.WG_CLIENT.getDirectoryName()));
                        File ALLUSERSPROFILE = new File(StringUtils.defaultString((String)System.getenv("ALLUSERSPROFILE"), (String)System.getProperty("user.home")));
                        File proxyDir = new File(ALLUSERSPROFILE, ".proxy");
                        if (proxyDir.exists() && !(newProxyDir = DirectoryService.getInstance().getProjectProxyDirectory()).exists()) {
                            FileUtils.copyDirectory((File)proxyDir, (File)newProxyDir);
                        }
                        if ((jumpDir = new File(WebGisClient.USERPROFILE, ".jump")).exists() && !(newJumpDir = DirectoryService.getInstance().getProjectDirectory(ProjectType.JUMP)).exists()) {
                            FileUtils.copyDirectory((File)jumpDir, (File)new File(TEMPDIR, ProjectType.JUMP.getDirectoryName()));
                        }
                        for (File file : files = TEMPDIR.listFiles()) {
                            if (!file.isDirectory()) continue;
                            FileUtils.moveDirectoryToDirectory((File)file, (File)localAppDirectory, (boolean)false);
                        }
                        TEMPDIR.delete();
                        for (File file : workbenchFiles = DirectoryService.getInstance().getProjectDirectory(ProjectType.JUMP).listFiles()) {
                            if (!file.getName().contains("workbench")) continue;
                            FileUtils.moveFileToDirectory((File)file, (File)new File(sharedAppDirectory, ProjectType.JUMP.getDirectoryName()), (boolean)true);
                        }
                        for (File file : settingFiles = DirectoryService.getInstance().getProjectDirectory(ProjectType.WG_CLIENT).listFiles()) {
                            if (!file.getName().contains("setting")) continue;
                            FileUtils.moveFileToDirectory((File)file, (File)new File(sharedAppDirectory, ProjectType.WG_CLIENT.getDirectoryName()), (boolean)true);
                        }
                        break block11;
                    }
                    LOG.error(String.format("Project temp directory could not be created!", new Object[0]));
                }
                catch (IOException ex) {
                    LOG.error(String.format("Migration of application data failed: %s", ex.getMessage()));
                }
            } else {
                this.checkAndCreateDirectories();
            }
        }
    }

    private void checkAndCreateDirectories() {
        File tmpDir = DirectoryService.getInstance().getProjectTempDirectory(ProjectType.WG_CLIENT);
        File logDir = DirectoryService.getInstance().getProjectLogDirectory(ProjectType.WG_CLIENT);
        File cacheDir = DirectoryService.getInstance().getProjectCacheDirectory(ProjectType.WG_CLIENT);
        File settingsDir = new File(DirectoryService.getInstance().getApplicationDataDirectory(), ProjectType.WG_CLIENT.getDirectoryName());
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        if (!settingsDir.exists()) {
            settingsDir.mkdirs();
        }
    }

    private void initInternalWhiteboard() throws SystemException {
        if (this.internalWb == null) {
            this.internalWb = new WhiteboardImpl();
            this.internalWb.setAttribute("GIS-HTTP-BRIDGE", (Object)WebGisConfiguration.getHttpBridgeURL());
            this.internalWb.setAttribute("GIS-WMS-SERVER", (Object)(WebGisConfiguration.getHttpBridgeURL() + "/webgis/ogc/wmsbridge"));
            this.internalWb.setAttribute("GIS-WMTS-SERVER", (Object)(WebGisConfiguration.getHttpBridgeURL() + "/webgis/wmts"));
            this.internalWb.setAttribute("GIS-3D-SERVER", (Object)(WebGisConfiguration.getHttpBridgeURL() + "/gis3d"));
        }
    }

    public static WebGisContext getInstance() {
        if (wgContext == null) {
            wgContext = new WebGisContext();
        }
        return wgContext;
    }

    public static Frame getWebGisClientFrame() {
        if (WebGisContext.getInstance() != null && WebGisContext.getInstance().getWebGisClient() != null) {
            return WebGisContext.getInstance().getWebGisClient().getFrame();
        }
        return null;
    }

    public WebGisClient getWebGisClient() {
        return WG_CLIENT;
    }

    public Whiteboard getPermWhiteboard() {
        if (this.permWb == null) {
            this.permWb = WhiteboardImpl.createWhiteboard((File)this.getWgClientSettingFile(), (XStream)WHITEBOARD_XSTREAM);
        }
        return this.permWb;
    }

    public boolean writePermWhiteboard() {
        return WhiteboardImpl.writeToFile((Whiteboard)this.permWb, (File)this.getWgClientSettingFile(), (XStream)WHITEBOARD_XSTREAM);
    }

    public Document getConfiguration() {
        return WG_CLIENT.getConfiguration();
    }

    public ServiceProvider getServiceProvider() {
        return WG_CLIENT.getServiceProvider();
    }

    public ServiceMData getService(String strSvcName, int intSvcVersion) {
        return ServiceRegistry.getService((String)strSvcName, (int)intSvcVersion);
    }

    public Map<String, Object> getUserInfo() {
        return WG_CLIENT.getServiceProvider().getUserInfo();
    }

    public void clearAllCaches() {
        this.clearModuleCache();
        RiwaSrvDataStore.clearMetaDataCache();
    }

    public void clearModuleCache() {
        lockLoadModule.lock();
        try {
            this.lstModules.clear();
        }
        finally {
            lockLoadModule.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<ModuleContext> getModules() throws ServiceException {
        lockLoadModule.lock();
        try {
            long timestart = System.currentTimeMillis();
            if (this.lstModules.isEmpty()) {
                ServiceMData moduleService = ServiceRegistry.getService((String)"module", (int)0);
                ServiceRequest req = moduleService.createRequest("get_modules", new LinkedHashMap());
                List lstModuleInfo = (List)this.getServiceProvider().execRequest(req).getResult();
                ArrayList<ModuleContext> modules = new ArrayList<ModuleContext>();
                for (Map mapModuleInfo : lstModuleInfo) {
                    modules.add(new WebGisModule(mapModuleInfo, this));
                }
                this.lstModules = modules;
            }
            long timeend = System.currentTimeMillis();
            LOG.trace("Module-Load: {}", (Object)(timeend - timestart));
            Iterator<ModuleContext> iterator = this.lstModules.iterator();
            return iterator;
        }
        finally {
            lockLoadModule.unlock();
        }
    }

    public ModuleContext getModule(String strModuleID) throws Exception {
        return this.getModule(Integer.parseInt(strModuleID));
    }

    public WebGisModule getModule(int _intModuleKey) throws Exception {
        Iterator<ModuleContext> i = this.getModules();
        while (i.hasNext()) {
            WebGisModule mod = (WebGisModule)i.next();
            if (mod.getKey() != _intModuleKey) continue;
            return mod;
        }
        return null;
    }

    public File getMapDefinition() throws Exception {
        long timestart = System.currentTimeMillis();
        ServiceMData mapService = ServiceRegistry.getService((String)"map", (int)0);
        File mapFile = new File(DirectoryService.getInstance().getProjectCacheDirectory(ProjectType.WG_CLIENT), "webgis_map.jmp");
        boolean useCachedMapFile = false;
        if (mapFile.exists()) {
            try {
                long lngChecksum = FileUtils.checksumCRC32((File)mapFile);
                LinkedHashMap<String, Long> mapParam = new LinkedHashMap<String, Long>();
                mapParam.put("checksum", lngChecksum);
                ServiceRequest reqMapCurrent = mapService.createRequest("is_map_current", mapParam);
                useCachedMapFile = (Boolean)this.getServiceProvider().execRequest(reqMapCurrent).getResult();
            }
            catch (ServiceException | IOException e) {
                LOG.error("Error at finding out if cached map file is up to date.", e);
            }
        }
        if (!useCachedMapFile) {
            ServiceRequest reqMap = mapService.createRequest("get_map", new LinkedHashMap());
            reqMap.setStreamProcessor((StreamProcessor)new FileStreamProcessor(mapFile));
            mapFile = (File)this.getServiceProvider().execRequest(reqMap).getResult();
            LOG.info("Project file loaded from server.");
        } else {
            LOG.info("Project file retrieved from local cache.");
        }
        long timeend = System.currentTimeMillis();
        LOG.trace("Prj-Load: " + (timeend - timestart));
        return mapFile;
    }

    public Object getModuleAppObject(String strKey) throws Exception {
        this.initInternalWhiteboard();
        return this.internalWb.getAttribute(strKey);
    }

    public DialogContext[] getDialogs4Layer(String strID) throws Exception {
        ArrayList<WebGisDialog> lstDlgContext = new ArrayList<WebGisDialog>();
        Iterator<ModuleContext> iMod = this.getModules();
        while (iMod.hasNext()) {
            DialogContext[] arrDialogs;
            WebGisModule mod = (WebGisModule)iMod.next();
            for (DialogContext arrDialog : arrDialogs = mod.getDialogs()) {
                WebGisDialog wgDlg = (WebGisDialog)arrDialog;
                if (!wgDlg.hasDialogMap() || !wgDlg.getDialogMap().hasLayer(strID)) continue;
                lstDlgContext.add(wgDlg);
            }
        }
        return lstDlgContext.toArray(new DialogContext[lstDlgContext.size()]);
    }

    public LayerContext[] getLayers4Dialog(String strModuleID, String strDialogID) throws Exception {
        WebGisDialog wgDlg = (WebGisDialog)this.getModule(strModuleID).getDialog(strDialogID);
        String[] arrLayerIDs = new String[]{};
        if (wgDlg.hasDialogMap()) {
            arrLayerIDs = wgDlg.getDialogMap().getLinkedLayerIDs();
        }
        ArrayList<LayerContext> lstLayerContext = new ArrayList<LayerContext>();
        for (String arrLayerID : arrLayerIDs) {
            LayerContext layerContext = WebGisClient.GIS_CONTEXT.getMapApp().getActiveMap().getMapLayer(arrLayerID);
            if (layerContext == null) continue;
            lstLayerContext.add(layerContext);
        }
        return lstLayerContext.toArray(new LayerContext[lstLayerContext.size()]);
    }

    public String[] getFileList(String strFileType) throws Exception {
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put("usr_file_type", strFileType);
        ServiceRequest req = ServiceRegistry.getService((String)"http-login", (int)0).createRequest("get_user_filelist", param);
        List lstFiles = (List)this.getServiceProvider().execRequest(req).getResult();
        return lstFiles.toArray(new String[lstFiles.size()]);
    }

    public File getFile(String strFileType, String strFileName) throws Exception {
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put("usr_file_type", strFileType);
        param.put("usr_file_name", strFileName);
        ServiceRequest req = ServiceRegistry.getService((String)"http-login", (int)0).createRequest("get_user_file", param);
        File tempFile = new File(DirectoryService.getInstance().getProjectTempDirectory(ProjectType.WG_CLIENT), new Date().getTime() + ".tmp");
        req.setStreamProcessor((StreamProcessor)new FileStreamProcessor(tempFile));
        this.getServiceProvider().execRequest(req);
        return tempFile;
    }

    public File getLogDir() {
        return DirectoryService.getInstance().getProjectLogDirectory(ProjectType.WG_CLIENT);
    }

    public int getVersion() {
        String[] split = this.getVersionText().split(Pattern.quote("."));
        return Integer.parseInt(split[0] + split[1] + split[2]);
    }

    public String getVersionText() {
        ServerInfo serverInfo = ((HttpServiceProvider)this.getServiceProvider()).getServerInfo();
        String strVersion = serverInfo.getServerVersion((HttpServiceProvider)this.getServiceProvider());
        if (StringUtils.isEmpty((CharSequence)strVersion)) {
            throw new IllegalStateException("Server version should allways be specified");
        }
        return strVersion;
    }

    public Optional<String> getVersionWithHotfix() {
        ServerInfo serverInfo = ((HttpServiceProvider)this.getServiceProvider()).getServerInfo();
        return Optional.ofNullable(serverInfo.getServerVersionWithHotfix((HttpServiceProvider)this.getServiceProvider()));
    }

    public Collection<SelectionExternalCall> getUserTriggerableExternalCalls() {
        return this.externalCallService.getUserTriggerableSelectionExternalCalls();
    }

    public String getInterfaceConfigurationFiles() {
        return this.interfaceConfigurationFiles.stream().map(Path::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    public void invokeExternalCall(String action, Collection<String> fids) {
        this.externalCallService.invokeForFIDs(action, fids);
    }

    public void invokeExternalCall(String action, Map<String, String> parameters) {
        this.externalCallService.invokePlain(action, parameters);
    }

    public boolean invokeExternalCallForLayerSelection(VectorLayerContext vectorLayerContext) {
        return this.externalCallService.invokeForLayerSelection(vectorLayerContext);
    }

    public void invokeExternalCallHook(ExternalCallHookEvent event) {
        this.externalCallService.invokeHook(event);
    }

    public boolean isSelectionValidForExternalCall(String action) {
        return this.externalCallService.qualifiesSelectionForExternalCall(action);
    }

    public void invokeExternalCallForSelection(String action) {
        this.externalCallService.invokeForAllLayerSelections(action);
    }

    public Set<LayerContext> getLayers4QuickInfo() throws Exception {
        return this.quickInfoService.getQuickInfoLayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<QuickInfoList> sendQuickInfoRequest(QuickInfoRequest request) {
        QuickInfoService quickInfoService = this.quickInfoService;
        synchronized (quickInfoService) {
            return this.quickInfoService.sendQuickInfoRequest(request);
        }
    }

    public Set<String> getLayersWithoutTooltips() throws Exception {
        return this.quickInfoService.getLayersWithoutTooltips();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeQuickInfos(QuickInfoList quickInfos) {
        QuickInfoService quickInfoService = this.quickInfoService;
        synchronized (quickInfoService) {
            this.quickInfoService.consumeQuickInfos(quickInfos);
        }
    }

    public void invokeQuickInfoAction(QuickInfoAction action) {
        this.quickInfoService.invokeQuickInfoAction(action);
    }

    public DmsService getDmsService() {
        return this.dmsService;
    }

    public File getWgClientSettingFile() {
        if (this.wgClientSettingFile == null) {
            this.wgClientSettingFile = new File(new File(DirectoryService.getInstance().getApplicationDataDirectory(), ProjectType.WG_CLIENT.getDirectoryName()), "settings.xml");
        }
        return this.wgClientSettingFile;
    }

    private boolean shouldWebGisClientBeMigrated() {
        File sharedFiles = new File(DirectoryService.getInstance().getApplicationDataDirectory(), ProjectType.WG_CLIENT.getDirectoryName());
        File localFiles = DirectoryService.getInstance().getProjectDirectory(ProjectType.WG_CLIENT);
        return !sharedFiles.exists() && !localFiles.exists() && WGCLIENT_DIR_OLD.exists();
    }

    public void close() {
        for (Runnable listener : this.applicationCloseListeners) {
            listener.run();
        }
    }

    public void addApplicationCloseListener(Runnable closeListener) {
        this.applicationCloseListeners.add(closeListener);
    }

    public ExternalCallService getExternalService() {
        return this.externalCallService;
    }

    public int getClientAPILevel() {
        return CLIENT_API_LEVEL;
    }

    public String getClientVersion() {
        return CLIENT_VERSION;
    }

    private static XStream createSecuredWhiteboardXStream() {
        XStream xstream = new XStream();
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.addPermission(ArrayTypePermission.ARRAYS);
        xstream.allowTypeHierarchy(Collection.class);
        xstream.allowTypeHierarchy(Map.class);
        xstream.allowTypeHierarchy(File.class);
        xstream.allowTypes(new Class[]{String.class});
        xstream.registerConverter((SingleValueConverter)new GenericFileConverter());
        return xstream;
    }

    static {
        LOG = LoggerFactory.getLogger(WebGisContext.class);
        WGCLIENT_DIR_OLD = new File(WebGisClient.USERPROFILE, ".wgClient");
        wgContext = null;
        lockLoadModule = new ReentrantLock();
        Properties prop = new Properties();
        try {
            prop.load(WebGisContext.class.getResourceAsStream("/version.properties"));
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere((String)"Error while retrieving version.");
        }
        CLIENT_VERSION = prop.getProperty("version.text");
        VERSION_NUMBER = CLIENT_API_LEVEL = Integer.valueOf(prop.getProperty("version.number")).intValue();
        Objects.requireNonNull(CLIENT_VERSION);
        Objects.requireNonNull(CLIENT_API_LEVEL);
    }
}

