/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli;

import de.riwagis.util.Config;
import de.riwagis.util.Whiteboard;
import de.riwagis.util.WhiteboardImpl;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.i18n.I18N;
import de.riwagis.util.logging.LogSupport;
import de.riwagis.util.network.NetworkSupport;
import de.riwagis.util.xml.XMLSupport;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.servlet.Gis3DProxyServlet;
import de.riwagis.webgiscli.servlet.GrafanaProxyServlet;
import de.riwagis.webgiscli.servlet.HttpBridgeServlet;
import de.riwagis.webgiscli.servlet.LocalActionServlet;
import jakarta.servlet.MultipartConfigElement;
import java.net.BindException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebGisConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger((String)WebGisConfiguration.class.getName());
    public static final Namespace NS_CFG = Namespace.getNamespace((String)"cfg", (String)"http://www.riwagis.de/config_webgis_cli");
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private static int intBridgePort = -1;
    private static boolean bolScanPorts = true;
    private static WebGisContext wgContextInternal = null;
    private static final Whiteboard wb = new WhiteboardImpl();
    private static boolean bolBridgeUp = false;
    private static String strHttpBridgeIP = null;

    public static Whiteboard getWhiteboard() {
        return wb;
    }

    public static WebGisContext getWebGisContext() {
        return wgContextInternal;
    }

    public static void setupConfig(WebGisContext wgContext) throws SystemException {
        wgContextInternal = wgContext;
        WebGisConfiguration.setUpHttpBridge();
    }

    public static String getHttpBridgeIP() throws SystemException {
        if (strHttpBridgeIP == null) {
            try {
                Element elemRoot = wgContextInternal.getConfiguration().getRootElement();
                Namespace ns = elemRoot.getNamespace();
                strHttpBridgeIP = elemRoot.getChild("services", ns).getChild("http", ns).getChildTextTrim("httpbridge_ip", ns);
            }
            catch (Exception e) {
                strHttpBridgeIP = NetworkSupport.getIPAdress();
            }
        }
        return strHttpBridgeIP;
    }

    public static String getHttpBridgeURL() throws SystemException {
        if (intBridgePort == -1) {
            throw new SystemException("HTTP bridge has not been set up.");
        }
        return "http://" + WebGisConfiguration.getHttpBridgeIP() + ":" + intBridgePort;
    }

    private static void setUpHttpBridge() throws SystemException {
        try {
            if (bolBridgeUp) {
                return;
            }
            QueuedThreadPool serverExecutor = new QueuedThreadPool();
            serverExecutor.setName("jetty");
            Server server = new Server((ThreadPool)serverExecutor);
            ServerConnector connector = new ServerConnector(server);
            server.addConnector((Connector)connector);
            if (intBridgePort == -1) {
                try {
                    Element elemPort = XMLSupport.getElement((Document)wgContextInternal.getConfiguration(), (Namespace)NS_CFG, (String)"/cfg:config_webgis_cli/cfg:services/cfg:http/cfg:httpbridge_port");
                    intBridgePort = Integer.parseInt(elemPort.getText());
                }
                catch (NumberFormatException | JDOMException e) {
                    intBridgePort = 8444;
                }
                try {
                    Element elemScanPort = XMLSupport.getElement((Document)wgContextInternal.getConfiguration(), (Namespace)NS_CFG, (String)"/cfg:config_webgis_cli/cfg:services/cfg:http/cfg:httpbridge_portscan");
                    int intPortScan = Integer.parseInt(elemScanPort.getText());
                    if (intPortScan == 0) {
                        bolScanPorts = false;
                    }
                }
                catch (NumberFormatException | JDOMException e) {
                    bolScanPorts = true;
                }
            }
            if (bolScanPorts) {
                int counter = 0;
                while (!NetworkSupport.isPortAvailable((int)intBridgePort)) {
                    ++intBridgePort;
                    if (++counter <= 100) continue;
                    throw new SystemException("Portscan failed.");
                }
            }
            ServerConnector serverConnector = connector;
            serverConnector.setPort(intBridgePort);
            serverConnector.setHost(WebGisConfiguration.getHttpBridgeIP());
            server.setConnectors(new Connector[]{connector});
            ServletContextHandler context = new ServletContextHandler();
            context.setContextPath("/");
            context.setMaxFormContentSize(16000000);
            context.addServlet(HttpBridgeServlet.class, "/*");
            context.addServlet(Gis3DProxyServlet.class, "/gis3d/*");
            context.addServlet(GrafanaProxyServlet.class, "/grafana/*");
            context.addServlet(LocalActionServlet.class, "/local").getRegistration().setMultipartConfig(new MultipartConfigElement(""));
            HandlerCollection handlers = new HandlerCollection();
            handlers.setHandlers(new Handler[]{context, new DefaultHandler()});
            server.setHandler((Handler)handlers);
            server.start();
            wb.setAttribute("HttpBridgeURL", (Object)WebGisConfiguration.getHttpBridgeURL());
            bolBridgeUp = true;
            LOG.info("JETTY UP");
        }
        catch (Exception e) {
            if (e instanceof BindException) {
                GUISupport.msgbox(null, (String)i18n.get("WebGisConfiguration.only-one-app"), (String)i18n.get("common.error"));
                throw new SystemException(WebGisConfiguration.class, (Throwable)e);
            }
            LogSupport.log((String)"webgiscli", (int)4, (String)"Error setting up JETTY");
            throw new SystemException(WebGisConfiguration.class, (Throwable)e);
        }
    }

    static {
        System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", "600000");
    }
}

