/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli;

import de.riwagis.browser.WindowManager;
import de.riwagis.browser.WindowManagerSettings;
import de.riwagis.browser.jxbrowser.JxWindowManagerProvider;
import de.riwagis.gis.context.AppStartup;
import de.riwagis.gis.context.GisContext;
import de.riwagis.gis.context.map.MapContext;
import de.riwagis.gis.context.module.ModuleAppContext;
import de.riwagis.icons.IconLoader;
import de.riwagis.service.ServiceException;
import de.riwagis.service.ServiceProvider;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.util.Config;
import de.riwagis.util.PropertiesSupport;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.LaFHelper;
import de.riwagis.util.i18n.I18N;
import de.riwagis.util.jdom.JDOMUtils;
import de.riwagis.util.logging.LogSupport;
import de.riwagis.util.system.SystemSupport;
import de.riwagis.util.xml.XMLSupport;
import de.riwagis.webgiscli.WebGisConfiguration;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.gui.MenuFrame;
import de.riwagis.webgiscli.gui.SplashPanel;
import de.riwagis.webgiscli.gui.SplashWindow;
import de.riwagis.webgiscli.interfaces.ExternalCallHookEvent;
import de.riwagis.webgiscli.interfaces.GenericInterfaceService;
import de.riwagis.webgiscli.login.gui.ModuleInfoListener;
import de.riwagis.webgiscli.login.gui.UserWarningsListener;
import de.riwagis.webgiscli.module.bsh.BshMenuRuntime;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import de.riwagis.webgiscli.util.DangerousPathChecker;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Supplier;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebGisClient {
    private static final Logger LOG = LoggerFactory.getLogger(WebGisClient.class);
    private static final Map<String, Object> mapArgs = new HashMap<String, Object>();
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");
    private static SplashWindow SPLASH;
    public static GisContext GIS_CONTEXT;
    private final WebGisContext wgContext;
    private final ServiceProvider svProvider;
    private final Document docConfig;
    private final File configFile;
    private Frame appFrame = null;
    public static final File USERPROFILE;
    public static final File INTERFACE_DIR;
    private static final File INTERFACE_FILE;
    public static final Map<String, File> interfaceInstallationPath;
    private static final String ICON_WEBCLIENT = "app-icon-client.ico";
    private final GenericInterfaceService genericInterfaceService;
    private final Timer interfaceTimer = new Timer(500, e -> {
        block8: {
            try {
                MapContext ctxMap;
                if (!INTERFACE_FILE.exists()) break block8;
                if (GIS_CONTEXT != null && ((ctxMap = GIS_CONTEXT.getMapApp().getActiveMap()) == null || !ctxMap.isInitialized() || ctxMap.isRendering())) {
                    return;
                }
                try {
                    Integer modKey;
                    List interfaceContents = FileUtils.readLines((File)INTERFACE_FILE, (String)"Cp1252");
                    WebGisClient.deleteInterfaceFile();
                    try {
                        modKey = Integer.valueOf((String)interfaceContents.remove(0));
                    }
                    catch (NumberFormatException nfex) {
                        throw new SystemException(String.format("illegal module key: '%s'", interfaceContents.get(0)), (Throwable)nfex);
                    }
                    String strBsh = StringUtils.join((Collection)interfaceContents, (String)"\n");
                    SwingUtilities.invokeLater(() -> {
                        if (this.appFrame != null) {
                            this.appFrame.setAlwaysOnTop(true);
                            this.appFrame.requestFocus();
                            this.appFrame.setAlwaysOnTop(false);
                            if (this.appFrame.getState() == 1) {
                                this.appFrame.setState(6);
                            }
                        }
                    });
                    final BshMenuRuntime rt = BshMenuRuntime.getInstance(strBsh, WebGisContext.getInstance(), modKey);
                    Thread thInterface = new Thread(this, "ThInterface"){

                        @Override
                        public void run() {
                            rt.onClick();
                        }
                    };
                    SwingUtilities.invokeLater(thInterface::start);
                }
                finally {
                    WebGisClient.deleteInterfaceFile();
                }
            }
            catch (Exception ex) {
                ExceptionDialog.handleGuiException(null, (Throwable)ex, (String)"webgiscli");
            }
        }
    });

    public static void initInterfaceInstallationPath(File iniFile, Map<String, File> interfaceInstallationPaths) {
        try {
            LOG.debug("Reading special Paths from INI-File: {}", (Object)iniFile.getAbsolutePath());
            if (iniFile.isFile()) {
                Properties p = PropertiesSupport.loadProperties((File)iniFile);
                for (Object currModKey : p.keySet()) {
                    if (!(currModKey instanceof String)) continue;
                    String string = (String)currModKey;
                    interfaceInstallationPaths.put(string, new File((String)p.get(currModKey)));
                }
            }
        }
        catch (IOException ex) {
            LOG.error(String.format("Error initializing interfaceInstallationPaths: %s", iniFile), (Throwable)ex);
        }
    }

    public static File determineInterfaceINIExe(String moduleKey) {
        return interfaceInstallationPath.get(moduleKey);
    }

    public WebGisClient(File strConfigFile) throws SystemException {
        try {
            this.docConfig = JDOMUtils.build((File)strConfigFile);
            this.configFile = strConfigFile;
            WebGisContext.WG_CLIENT = this;
            this.wgContext = WebGisContext.getInstance();
            if (GIS_CONTEXT != null) {
                GIS_CONTEXT.setModuleApp((ModuleAppContext)this.wgContext);
            }
            this.setupLogging();
            this.initWindowManager(Objects.equals(mapArgs.get("testMode"), true));
            this.svProvider = this.setupProvider();
            this.setupPrompGC();
            WebGisClient.initInterfaceInstallationPath(new File(strConfigFile.getParentFile(), "interface.ini"), interfaceInstallationPath);
            this.checkNetworkDriveExecution();
            WebGisConfiguration.setupConfig(this.wgContext);
            this.genericInterfaceService = new GenericInterfaceService(Runtime.getRuntime(), () -> WebGisConfiguration.getHttpBridgeURL());
            this.genericInterfaceService.registerGenericInterface();
            boolean bolSuccess = this.svProvider.doLogin();
            if (bolSuccess) {
                ArrayList<String> lstArgs = new ArrayList<String>();
                if (!this.svProvider.getUserInfo().containsKey("usr_gis_author") || !((Boolean)this.svProvider.getUserInfo().get("usr_gis_author")).booleanValue()) {
                    lstArgs.add("-viewer");
                }
                String[] arrArgs = (String[])lstArgs.toArray(String[]::new);
                this.start(arrArgs);
            } else {
                WindowManager.getInstance().shutdown();
                System.exit(0);
            }
        }
        catch (SystemException e2) {
            throw e2;
        }
        catch (ServiceException | IOException | JDOMException e3) {
            throw new SystemException(WebGisClient.class, e3.getMessage(), e3);
        }
    }

    public final void setupLogging() {
        String log4JFilePath = "log4gis2.xml";
        File log4JFile = new File("log4gis2.xml");
        if (log4JFile.exists()) {
            try {
                File logDir = DirectoryService.getInstance().getProjectLogDirectory(ProjectType.WG_CLIENT);
                if (!logDir.exists()) {
                    logDir.mkdirs();
                }
                System.setProperty("application.logdir", logDir.getAbsolutePath() + File.separator);
            }
            catch (Exception e) {
                System.out.println("error: cannot create logdir");
            }
            LogSupport.addXMLConfigurationFile((String)"log4gis2.xml");
        }
    }

    public void setupLocalInterface() {
        INTERFACE_DIR.mkdirs();
        if (INTERFACE_DIR.isDirectory()) {
            LOG.info("Starting local interface timer for file: {} (Dir: {})", (Object)INTERFACE_FILE, (Object)INTERFACE_DIR);
            this.interfaceTimer.start();
        }
    }

    private ServiceProvider setupProvider() throws SystemException {
        try {
            Element elemHtml = XMLSupport.getElement((Document)this.getConfiguration(), (Namespace)WebGisConfiguration.NS_CFG, (String)"/cfg:config_webgis_cli/cfg:services/cfg:type");
            if (!elemHtml.getTextTrim().equals("http")) {
                throw new SystemException(this.getClass(), "invalid service provider in config file");
            }
            HttpServiceProvider prov = new HttpServiceProvider(this.wgContext);
            prov.addLogoutListener(e -> {
                try {
                    WindowManager.getInstance().closeAll();
                    WebGisContext.getInstance().clearAllCaches();
                }
                catch (SystemException err) {
                    LOG.error("Error at logout.", (Throwable)err);
                }
            });
            return prov;
        }
        catch (SystemException | JDOMException e2) {
            throw new SystemException(WebGisClient.class, e2.getMessage(), e2);
        }
    }

    private void setupPrompGC() {
        try {
            String strPromtGC;
            Namespace ns = this.getConfiguration().getRootElement().getNamespace();
            Element elemSystem = this.getConfiguration().getRootElement().getChild("system", ns);
            if (elemSystem != null && StringUtils.isNotBlank((String)(strPromtGC = elemSystem.getChildTextTrim("promptgc", ns)))) {
                float fltFreeRatio = Float.parseFloat(strPromtGC);
                SystemSupport.StartPromtGCTimer((float)fltFreeRatio);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("Initializing prompt garbage collection caused error.", (Throwable)e);
        }
    }

    private void setup3D() {
        try {
            String gis3dmappath;
            Namespace ns = this.getConfiguration().getRootElement().getNamespace();
            Element elemSystem = this.getConfiguration().getRootElement().getChild("gis3d", ns);
            if (elemSystem != null && StringUtils.isNotBlank((String)(gis3dmappath = elemSystem.getChildTextTrim("mappath", ns)))) {
                GIS_CONTEXT.getMapApp().getGIS3DContext().setMapPath(gis3dmappath);
            }
        }
        catch (Exception e) {
            LOG.warn("Initializing 3d GIS caused error.", (Throwable)e);
        }
    }

    private void start(String[] args) throws SystemException {
        try {
            if (GIS_CONTEXT != null) {
                AppStartup.startUpMap((String[])args);
                this.setupDWG();
                this.setup3D();
                this.appFrame = GIS_CONTEXT.getMapApp().getFrame();
            } else {
                this.appFrame = this.createWebClient();
            }
            String applicationName = this.appFrame.getTitle();
            Supplier<String> titleSupplier = () -> WebGisClient.buildTitle(applicationName, (HttpServiceProvider)this.svProvider);
            this.svProvider.addLoginListener(e -> this.appFrame.setTitle((String)titleSupplier.get()));
            SwingUtilities.invokeLater(() -> {
                WindowManager.getInstance().setFallbackParentFrame(this.appFrame);
                this.appFrame.addWindowListener(new WindowAdapter(this){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        WebGisClient.getSplash().setVisible(false);
                    }
                });
                this.appFrame.setTitle((String)titleSupplier.get());
                this.appFrame.setVisible(true);
                this.appFrame.toFront();
            });
            this.registerInterfaceHookListeners();
            this.registerAndInvokeMissingModulesListener();
            this.registerModuleInfoListener();
            this.wgContext.addApplicationCloseListener(() -> WindowManager.getInstance().shutdown());
            this.wgContext.addApplicationCloseListener(this::deleteOldTemporaryFiles);
            this.wgContext.addApplicationCloseListener(this::closeServerConnection);
            this.wgContext.addApplicationCloseListener(this.genericInterfaceService::deregisterGenericInterface);
            this.setupLocalInterface();
        }
        catch (Exception e2) {
            throw new SystemException(this.getClass(), (Throwable)e2);
        }
    }

    private void deleteOldTemporaryFiles() {
        FileSupport.cleanDirectory((File)DirectoryService.getInstance().getProjectTempDirectory(ProjectType.WG_CLIENT), (long)0L, (boolean)true);
    }

    private void closeServerConnection() {
        try {
            this.svProvider.doLogout();
            this.svProvider.close();
        }
        catch (ServiceException | IOException se) {
            LOG.error("Error at logout.", se);
        }
    }

    private void registerInterfaceHookListeners() {
        if (GIS_CONTEXT == null) {
            return;
        }
        this.wgContext.addApplicationCloseListener(() -> this.wgContext.invokeExternalCallHook(ExternalCallHookEvent.SHUTDOWN));
        this.svProvider.addLoginListener(e -> this.wgContext.invokeExternalCallHook(ExternalCallHookEvent.LOGIN));
        this.wgContext.invokeExternalCallHook(ExternalCallHookEvent.LOGIN);
        this.svProvider.addLogoutListener(e -> this.wgContext.invokeExternalCallHook(ExternalCallHookEvent.LOGOUT));
    }

    private MenuFrame createWebClient() {
        MenuFrame menuFrame = new MenuFrame(this.wgContext);
        try {
            menuFrame.setIconImages(IconLoader.getIconImagesOfIcoFile((String)ICON_WEBCLIENT));
        }
        catch (IOException | IllegalArgumentException ex) {
            LOG.warn(String.format("Error loading frame icon: '%s'", ICON_WEBCLIENT), (Throwable)ex);
        }
        menuFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WebGisClient.this.wgContext.close();
            }
        });
        return menuFrame;
    }

    private void registerAndInvokeMissingModulesListener() {
        UserWarningsListener missingModulesListener = new UserWarningsListener(this.svProvider, this.appFrame);
        this.svProvider.addLoginListener((ActionListener)missingModulesListener);
        missingModulesListener.actionPerformed(null);
    }

    private void registerModuleInfoListener() {
        ModuleInfoListener moduleInfoListener = new ModuleInfoListener(this.svProvider);
        this.svProvider.addLoginListener((ActionListener)moduleInfoListener);
        moduleInfoListener.actionPerformed(null);
    }

    public static String buildTitle(String defaultName, HttpServiceProvider svProvider) {
        Object loginName = StringUtils.isBlank((String)svProvider.getSubUser()) ? (String)svProvider.getUserInfo().get("usr_login_name") : String.valueOf(svProvider.getUserInfo().get("usr_login_name")) + " --> " + svProvider.getSubUser();
        return MessageFormat.format("{0}@{1} - {2}", defaultName, svProvider.getServer().replaceAll("https?\\:\\/\\/", ""), loginName);
    }

    public Frame getFrame() {
        return this.appFrame;
    }

    public Document getConfiguration() {
        return this.docConfig;
    }

    public WebGisContext getWebGisContext() {
        return this.wgContext;
    }

    public ServiceProvider getServiceProvider() {
        return this.svProvider;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    private static void parseParameters(String[] args) {
        String lastKey = null;
        for (String strKey : args) {
            if (strKey.length() < 2) continue;
            if (strKey.startsWith("-")) {
                if (lastKey != null) {
                    mapArgs.put(lastKey.substring(1), true);
                }
                lastKey = strKey;
                continue;
            }
            if (lastKey == null) continue;
            mapArgs.put(lastKey.substring(1), strKey);
            lastKey = null;
        }
        if (lastKey != null) {
            mapArgs.put(lastKey.substring(1), true);
        }
    }

    private void setupDWG() {
        try {
            String dwgUrl;
            Namespace ns = this.getConfiguration().getRootElement().getNamespace();
            Element elemSystem = this.getConfiguration().getRootElement().getChild("dwgconverter", ns);
            if (elemSystem != null && StringUtils.isNotBlank((String)(dwgUrl = elemSystem.getChildTextTrim("url", ns)))) {
                this.wgContext.getUserInfo().put("usr_dwg_service_url", dwgUrl);
            }
        }
        catch (Exception e) {
            LOG.warn("Initializing DWG Converter URL caused error.", (Throwable)e);
        }
    }

    public static void startup(String[] args, GisContext gisContext) {
        GIS_CONTEXT = gisContext;
        WebGisClient.main(args);
    }

    public static void main(String[] args) {
        WebGisClient.parseParameters(args);
        if (mapArgs.containsKey("h")) {
            System.out.println("Usage: WebGisClient");
            System.out.println("[ -c Absolute path to config.xml]");
            System.out.println("[ -h for help]");
            return;
        }
        String strConfigFileTmp = mapArgs.containsKey("c") ? (String)mapArgs.get("c") : "config.xml";
        File strConfigFile = new File(strConfigFileTmp);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        LaFHelper.initLookAndFeel();
        Runnable run = () -> {
            WebGisClient.getSplash().setVisible(true);
            WebGisClient wgClient = null;
            try {
                wgClient = new WebGisClient(strConfigFile);
            }
            catch (SystemException e) {
                ExceptionDialog.handleGuiException(null, (Throwable)e, (String)"webgiscli");
                try {
                    Optional.ofNullable(wgClient).map(WebGisClient::getWebGisContext).ifPresent(ModuleAppContext::close);
                }
                catch (Exception e1) {
                    LOG.error("Error calling onAppClose", (Throwable)e1);
                }
                System.exit(0);
            }
        };
        Thread thStart = new Thread(run);
        thStart.start();
    }

    private void initWindowManager(boolean testMode) {
        WindowManagerSettings windowManagerSettings = new WindowManagerSettings();
        if (testMode) {
            windowManagerSettings.setDebugPort(8081);
            windowManagerSettings.setProviderFilter(JxWindowManagerProvider.class::isInstance);
        }
        windowManagerSettings.setCustomSettings(this.getCustomBrowserSettings());
        WindowManager.startup((WindowManagerSettings)windowManagerSettings);
    }

    public static synchronized SplashWindow getSplash() {
        if (SPLASH == null) {
            SPLASH = new SplashWindow(new SplashPanel(String.format("<html><div align='right'>%s %s / RIWA GmbH</div></html>", i18n.get("gui.HttpLoginFrame.version"), WebGisContext.getInstance().getClientVersion()), true));
        }
        return SPLASH;
    }

    public void checkNetworkDriveExecution() {
        boolean dangerous = new DangerousPathChecker().isDangerous(new File(System.getProperty("user.dir")));
        if (dangerous) {
            LOG.warn("Client was started from network drive. This can lead to instabilities!");
            if (this.suppressNetworkDriveWarning()) {
                LOG.info("Client is started from network drive, but warning is suppressed.");
                return;
            }
            JOptionPane.showMessageDialog(WebGisClient.getSplash(), i18n.get("WebGisClient.warning-network-share-exec"), i18n.get("common.warning"), 2);
        }
    }

    private boolean suppressNetworkDriveWarning() {
        Element rootElement = this.getConfiguration().getRootElement();
        if (rootElement == null) {
            return false;
        }
        String rawSuppressWarning = rootElement.getChildTextTrim("suppress_network_drive_warning", rootElement.getNamespace());
        return Objects.equals(rawSuppressWarning, "true");
    }

    private Map<String, String> getCustomBrowserSettings() {
        Namespace ns = this.getConfiguration().getRootElement().getNamespace();
        Element rootElement = this.getConfiguration().getRootElement();
        if (rootElement == null) {
            return Collections.emptyMap();
        }
        Element browserElement = rootElement.getChild("browser", ns);
        if (browserElement == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> settings = new HashMap<String, String>();
        for (Element child : browserElement.getChildren()) {
            settings.put(child.getName(), child.getTextTrim());
        }
        return settings;
    }

    public UUID getClientID() {
        return this.genericInterfaceService.getClientID();
    }

    private static void deleteInterfaceFile() {
        try {
            if (INTERFACE_FILE.exists() && !INTERFACE_FILE.delete()) {
                LOG.debug(String.format("unable to delete interface-file '%s': interface file not available", INTERFACE_FILE));
            }
        }
        catch (Exception e1) {
            LOG.warn(String.format("unable to delete inteface-file '%s': %s", INTERFACE_FILE, e1.getMessage()), (Throwable)e1);
        }
    }

    static {
        GIS_CONTEXT = null;
        USERPROFILE = new File(StringUtils.defaultString((String)System.getenv("USERPROFILE"), (String)System.getProperty("user.home")));
        INTERFACE_DIR = new File(USERPROFILE, "riwainterface");
        INTERFACE_FILE = new File(INTERFACE_DIR, "interface");
        interfaceInstallationPath = new HashMap<String, File>();
    }
}

