/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.webgiscli;

import de.riwagis.gis.context.map.debug.DebugInformation;
import de.riwagis.gis.context.map.debug.DebugInformationProvider;
import de.riwagis.gis.context.map.debug.DebugInformations;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.util.Config;
import de.riwagis.util.i18n.I18N;
import de.riwagis.webgiscli.WebGisContext;
import de.riwagis.webgiscli.login.ServerInfo;
import de.riwagis.webgiscli.service.http.HttpServiceProvider;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ClientDebugInformationProvider
implements DebugInformationProvider {
    private static final I18N i18n = new I18N(Config.LOCALE, "de.riwagis.webgiscli.i18n.i18n");

    public Set<DebugInformation> provide() {
        HashSet<DebugInformation> data = new HashSet<DebugInformation>();
        data.add(this.createDebugInfo("client.network-start-used", this.localizeBoolean(this.startedThroughNetworkSync())));
        data.add(this.createDebugInfo("client.network-start-exe", Path.of(Objects.requireNonNullElse(System.getenv("RGZ_NETWORK_EXE"), ""), new String[0])));
        WebGisContext context = WebGisContext.getInstance();
        if (context != null && context.getWebGisClient() != null) {
            HttpServiceProvider serviceProvider = (HttpServiceProvider)context.getServiceProvider();
            Map<String, Object> userInfo = context.getUserInfo();
            data.add(this.createDebugInfo("client.version", context.getClientVersion()));
            data.add(this.createDebugInfo("client.server-url", serviceProvider.getURL()));
            data.add(this.createDebugInfo("client.server-version", this.getServerVersion(context)));
            data.add(this.createDebugInfo("client.server-user", userInfo.get("usr_login_name")));
            data.add(this.createDebugInfo("client.server-subuser", serviceProvider.getSubUser()));
            data.add(this.createDebugInfo("client.server-login-method", this.getDisplayableLoginMethod(serviceProvider)));
            data.add(this.createDebugInfo("client.configuration-settings", context.getWgClientSettingFile()));
            data.add(this.createDebugInfo("client.configuration-interface", context.getInterfaceConfigurationFiles()));
            DirectoryService directoryService = DirectoryService.getInstance();
            data.add(this.createDebugInfo("client.directory-base", directoryService.getProjectDirectory(ProjectType.WG_CLIENT)));
            data.add(this.createDebugInfo("client.directory-cache", directoryService.getProjectCacheDirectory(ProjectType.WG_CLIENT)));
            data.add(this.createDebugInfo("client.directory-temp", directoryService.getProjectTempDirectory(ProjectType.WG_CLIENT)));
            data.add(this.createDebugInfo("client.directory-log", directoryService.getProjectLogDirectory(ProjectType.WG_CLIENT)));
        }
        return data;
    }

    private String getServerVersion(WebGisContext context) {
        return context.getVersionWithHotfix().orElse(String.valueOf(context.getVersion()));
    }

    private boolean startedThroughNetworkSync() {
        return Optional.ofNullable(System.getenv("RGZ_NETWORK_START")).filter(s -> "TRUE".equals(s)).isPresent();
    }

    public String getDisplayableLoginMethod(HttpServiceProvider serviceProvider) {
        ServerInfo serverInfo = serviceProvider.getServerInfo();
        ArrayList<String> authHandlers = new ArrayList<String>();
        if (serverInfo.isSingleSignOnLogin()) {
            authHandlers.add("SSO");
        }
        if (serverInfo.isLdap(serviceProvider)) {
            authHandlers.add("LDAP");
        }
        if (authHandlers.isEmpty()) {
            authHandlers.add("Standard");
        }
        return StringUtils.join(authHandlers, (String)", ");
    }

    private DebugInformation createDebugInfo(String key, Path value) {
        if (value == null) {
            return DebugInformations.createStringInformation((String)key, (String)this.localizeKey(key, key), null);
        }
        return DebugInformations.createPathInformation((String)key, (String)this.localizeKey(key, key), (Path)value);
    }

    private DebugInformation createDebugInfo(String key, File value) {
        if (value == null) {
            return DebugInformations.createStringInformation((String)key, (String)this.localizeKey(key, key), null);
        }
        return DebugInformations.createFileInformation((String)key, (String)this.localizeKey(key, key), (File)value);
    }

    private DebugInformation createDebugInfo(String key, Object value) {
        return DebugInformations.createStringInformation((String)key, (String)this.localizeKey(key, key), (Object)value);
    }

    private String localizeKey(String key, String i18nKey) {
        try {
            return i18n.get(this.getClass().getName() + "." + i18nKey);
        }
        catch (Exception e) {
            return key;
        }
    }

    private String localizeBoolean(boolean value) {
        if (value) {
            return i18n.get("de.riwagis.webgiscli.ClientDebugInformationProvider.client.yes");
        }
        return i18n.get("de.riwagis.webgiscli.ClientDebugInformationProvider.client.no");
    }
}

