/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.velocity.discovery;

import fr.opensagres.xdocreport.core.utils.Assert;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.discovery.ITemplateEngineDiscovery;
import fr.opensagres.xdocreport.template.velocity.VelocityConstants;
import fr.opensagres.xdocreport.template.velocity.cache.XDocReportEntryResourceLoader;
import fr.opensagres.xdocreport.template.velocity.internal.VelocityTemplateEngine;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class VelocityTemplateEngineDiscovery
implements ITemplateEngineDiscovery,
VelocityConstants {
    public ITemplateEngine createTemplateEngine() {
        Properties velocityDefaultProperties = this.getVelocityDefaultProperties();
        Assert.notNull((Object)velocityDefaultProperties, (String)"velocityDefaultProperties must not be null");
        return new VelocityTemplateEngine(this.getVelocityEngineProperties());
    }

    private synchronized Properties getVelocityEngineProperties() {
        Properties velocityEngineProperties = new Properties();
        Properties velocityDefaultProperties = this.getVelocityDefaultProperties();
        if (velocityDefaultProperties != null) {
            velocityEngineProperties.putAll((Map<?, ?>)velocityDefaultProperties);
        } else {
            velocityEngineProperties.setProperty("resource.loader", "file, class, jar ,report");
            velocityEngineProperties.setProperty("report.resource.loader.class", XDocReportEntryResourceLoader.class.getName());
            velocityEngineProperties.setProperty("report.resource.loader.cache", "true");
            velocityEngineProperties.setProperty("report.resource.loader.modificationCheckInterval", "1");
            try {
                if (Class.forName("org.apache.velocity.runtime.log.NullLogChute") != null) {
                    velocityEngineProperties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogChute");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return velocityEngineProperties;
    }

    private synchronized Properties getVelocityDefaultProperties() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("velocity.properties");
        if (is != null) {
            try {
                Properties p = new Properties();
                p.load(is);
                return p;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public String getDescription() {
        return "Manage Velocity template engine.";
    }

    public String getId() {
        return TemplateEngineKind.Velocity.name();
    }
}

