/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.velocity.cache;

import fr.opensagres.xdocreport.core.io.IEntryInfo;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.cache.ITemplateCacheInfoProvider;
import fr.opensagres.xdocreport.template.utils.TemplateUtils;
import fr.opensagres.xdocreport.template.velocity.VelocityConstants;
import java.io.InputStream;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class XDocReportEntryResourceLoader
extends ResourceLoader
implements VelocityConstants {
    private ITemplateEngine templateEngine = null;

    public void commonInit(RuntimeServices rs, ExtendedProperties configuration) {
        super.commonInit(rs, configuration);
        this.templateEngine = (ITemplateEngine)rs.getProperty("velocityTemplateEngine");
    }

    public void init(ExtendedProperties configuration) {
    }

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        InputStream inputStream;
        IEntryInfo cacheInfo = TemplateUtils.getTemplateCacheInfo((ITemplateCacheInfoProvider)this.templateEngine.getTemplateCacheInfoProvider(), (String)source);
        if (cacheInfo != null && (inputStream = cacheInfo.getInputStream()) != null) {
            return inputStream;
        }
        throw new ResourceNotFoundException("Cannot find input stream for the entry with source=" + source);
    }

    public boolean resourceExists(String resourceName) {
        ITemplateCacheInfoProvider templateCacheInfoProvider = this.templateEngine.getTemplateCacheInfoProvider();
        if (templateCacheInfoProvider == null) {
            return false;
        }
        IEntryInfo cacheInfo = TemplateUtils.getTemplateCacheInfo((ITemplateCacheInfoProvider)this.templateEngine.getTemplateCacheInfoProvider(), (String)resourceName);
        return cacheInfo != null;
    }

    public boolean isSourceModified(Resource resource) {
        return this.getLastModified(resource) != resource.getLastModified();
    }

    public long getLastModified(Resource resource) {
        String resourceName = resource.getName();
        IEntryInfo cacheInfo = TemplateUtils.getTemplateCacheInfo((ITemplateCacheInfoProvider)this.templateEngine.getTemplateCacheInfoProvider(), (String)resourceName);
        if (cacheInfo != null) {
            return cacheInfo.getLastModified();
        }
        return 0L;
    }
}

