/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.vectortiles;

import java.io.File;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorTilesUtil {
    private static final Logger LOG = LoggerFactory.getLogger(VectorTilesUtil.class);
    public static final String VECTOR_TILE_ENDING = ".rvt";

    public static String buildTilePath(String typeName, File dataSetbaseDir, int filterTextHashCode, int zoomLevel, int row, int col) {
        StringBuilder sbVectorTile = new StringBuilder();
        sbVectorTile.append(dataSetbaseDir.getPath()).append(File.separator);
        sbVectorTile.append(typeName).append(File.separator);
        sbVectorTile.append(filterTextHashCode).append(File.separator);
        sbVectorTile.append(zoomLevel).append(File.separator);
        sbVectorTile.append(row).append(File.separator);
        sbVectorTile.append(col);
        sbVectorTile.append(VECTOR_TILE_ENDING);
        String tilePath = sbVectorTile.toString();
        return tilePath;
    }

    public static ReferencedEnvelope buildTileBounds(ReferencedEnvelope bounds, int tileSize, int col, int row) throws MismatchedDimensionException {
        double minX = bounds.getMinX();
        double minY = bounds.getMinY();
        double tileX = minX + (double)(col * tileSize);
        double tileY = minY + (double)(row * tileSize);
        ReferencedEnvelope tileBounds = new ReferencedEnvelope(tileX, tileX + (double)tileSize, tileY, tileY + (double)tileSize, bounds.getCoordinateReferenceSystem());
        return tileBounds;
    }
}

