/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.unit;

import de.riwagis.unit.AbstractDrawingUnit;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitFactory {
    private static final Logger LOG = LoggerFactory.getLogger(UnitFactory.class);
    private static DrawingUnit defaultUnit = null;
    private static final Map<String, DrawingUnit> mapUnits = new HashMap<String, DrawingUnit>();
    private static final AtomicBoolean isInitialized = new AtomicBoolean(false);

    private UnitFactory() {
    }

    private static void fillUnits() {
        if (isInitialized.compareAndSet(false, true)) {
            LOG.info("initializing UnitFactory Units");
            ResourceBundle rb = ResourceBundle.getBundle(String.format("%s.unit", UnitFactory.class.getPackage().getName()), Config.LOCALE);
            Enumeration<String> keyEnum = rb.getKeys();
            while (keyEnum.hasMoreElements()) {
                String strKey = keyEnum.nextElement();
                String[] arrValues = rb.getString(strKey).split("\\|");
                boolean isDefaultUnit = arrValues[0].startsWith("_");
                String unitName = isDefaultUnit ? arrValues[0].substring(1) : arrValues[0];
                DrawingUnit unit = UnitFactory.createUnit(strKey, unitName, arrValues[1], Double.parseDouble(arrValues[2]), arrValues[3]);
                if (isDefaultUnit) {
                    defaultUnit = unit;
                }
                mapUnits.put(strKey, unit);
            }
        }
    }

    public static List<DrawingUnit> getUnitList() {
        UnitFactory.fillUnits();
        ArrayList<DrawingUnit> res = new ArrayList<DrawingUnit>(mapUnits.values());
        Collections.sort(res);
        return res;
    }

    public static List<String> getKeyList() {
        UnitFactory.fillUnits();
        ArrayList<String> res = new ArrayList<String>(mapUnits.keySet());
        Collections.sort(res);
        return res;
    }

    public static DrawingUnit getUnit(String strKey) {
        UnitFactory.fillUnits();
        return mapUnits.get(strKey);
    }

    public static DrawingUnit getDefaultUnit() {
        UnitFactory.fillUnits();
        return defaultUnit;
    }

    public static String getKey(DrawingUnit unit) {
        UnitFactory.fillUnits();
        for (String strKey : mapUnits.keySet()) {
            if (unit != mapUnits.get(strKey)) continue;
            return strKey;
        }
        return null;
    }

    private static DrawingUnit createUnit(final String strKey, final String strName, final String strAbbreviation, final double dblUnitInMeter, final String strSystem) {
        return new AbstractDrawingUnit(){

            @Override
            public String getKey() {
                return strKey;
            }

            @Override
            public double getUnitInMeter() {
                return dblUnitInMeter;
            }

            @Override
            public String getUnitName() {
                return strName;
            }

            @Override
            public String getUnitAbbreviation() {
                return strAbbreviation;
            }

            @Override
            public String getSystemName() {
                return strSystem;
            }
        };
    }
}

