/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.sbconv;

import de.riwagis.sbconv.InvalidObjectException;
import de.riwagis.sbconv.SBConverter;

public class StringBufferConverter
implements SBConverter {
    private final int length;

    StringBufferConverter(int _length) {
        this.length = _length;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Object getObject(StringBuffer sb, int start) {
        return new StringBuffer(sb.substring(start, start + this.length).trim());
    }

    @Override
    public void setObject(StringBuffer sb, int start, Object obj) throws InvalidObjectException {
        try {
            StringBuffer sbtemp = (StringBuffer)obj;
            if (sbtemp.length() > this.length) {
                throw new Exception("The StringBuffer is to large.");
            }
            sbtemp.setLength(this.length);
            sb.replace(start, start + this.length, sbtemp.toString());
        }
        catch (Exception e) {
            throw new InvalidObjectException("SBConverter error: " + e.getMessage());
        }
    }

    @Override
    public Class getConverterClass() {
        return StringBuffer.class;
    }
}

