/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.sbconv;

import de.riwagis.sbconv.InvalidObjectException;
import de.riwagis.sbconv.SBMapper;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SBMapperWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(SBMapperWrapper.class);
    private final Map mapObjCache = new LinkedHashMap();
    private StringBuffer sb = null;
    private SBMapper sbMap;

    public SBMapperWrapper(SBMapper _sbMap) throws InvalidObjectException {
        if (!_sbMap.isLocked()) {
            throw new InvalidObjectException("To use this object you have to lock the SBMapper.");
        }
        this.sbMap = _sbMap;
        this.setStringBuffer(this.sbMap.getEmptyBuffer());
    }

    public void setStringBuffer(StringBuffer _sb) throws InvalidObjectException {
        if (!this.sbMap.isLocked()) {
            throw new InvalidObjectException("To use this method you have to lock the SBMapper.");
        }
        if (_sb.length() > this.sbMap.getLength()) {
            throw new InvalidObjectException("The length of the StringBuffer is to large.");
        }
        if (_sb.length() < this.sbMap.getLength()) {
            _sb.setLength(this.sbMap.getLength());
        }
        Iterator<String> i = this.sbMap.keyIterator();
        while (i.hasNext()) {
            this.mapObjCache.put(i.next(), null);
        }
        this.sb = _sb;
    }

    public StringBuffer getStringBuffer() {
        return this.sb;
    }

    public void setObject(String name, Object obj) throws InvalidObjectException {
        this.sbMap.setObject(name, this.sb, obj);
        this.mapObjCache.put(name, obj);
    }

    public Object getObject(String name) throws InvalidObjectException {
        if (!this.sbMap.isLocked()) {
            throw new InvalidObjectException("To use this method you have to lock the SBMapper.");
        }
        if (this.mapObjCache.get(name) != null) {
            return this.mapObjCache.get(name);
        }
        Object obj = this.sbMap.getObject(name, this.sb);
        this.mapObjCache.put(name, obj);
        return obj;
    }

    public boolean setBoolean(String name, boolean bol) {
        try {
            this.setObject(name, bol);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean getBoolean(String name) {
        try {
            return (Boolean)this.getObject(name);
        }
        catch (Exception e) {
            LOG.warn("Unable to convert booleanValue: " + name, (Throwable)e);
            return false;
        }
    }

    public boolean setInt(String name, int intval) {
        try {
            this.setObject(name, intval);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getInt(String name) {
        try {
            return (Integer)this.getObject(name);
        }
        catch (Exception e) {
            LOG.warn("Unable to convert intValue: " + name, (Throwable)e);
            return -1;
        }
    }

    public boolean setLong(String name, long longval) {
        try {
            this.setObject(name, longval);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getLong(String name) {
        try {
            return (Long)this.getObject(name);
        }
        catch (Exception e) {
            LOG.warn("Unable to convert longValue: " + name, (Throwable)e);
            return -1L;
        }
    }

    public boolean setFloat(String name, float floatval) {
        try {
            this.setObject(name, Float.valueOf(floatval));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public float getFloat(String name) {
        try {
            return ((Float)this.getObject(name)).floatValue();
        }
        catch (Exception e) {
            LOG.warn("Unable to convert floatValue: " + name, (Throwable)e);
            return -1.0f;
        }
    }

    public boolean setDouble(String name, double doubleval) {
        try {
            this.setObject(name, doubleval);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public double getDouble(String name) {
        try {
            return (Double)this.getObject(name);
        }
        catch (Exception e) {
            LOG.warn("Unable to convert doubleValue: " + name, (Throwable)e);
            return -1.0;
        }
    }
}

