/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.sbconv;

import de.riwagis.sbconv.InvalidObjectException;
import de.riwagis.sbconv.LockedException;
import de.riwagis.sbconv.SBConverter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class SBMapper {
    private final Map<String, SBConverter> mapConverter = new LinkedHashMap<String, SBConverter>();
    private boolean locked = false;
    private int lockedLength = -1;

    public void addConverter(String name, SBConverter conv) throws LockedException, InvalidObjectException {
        if (this.mapConverter.containsKey(name)) {
            throw new InvalidObjectException("The key already exists.");
        }
        if (this.locked) {
            throw new LockedException("The SBMapper is already locked.");
        }
        this.mapConverter.put(name, conv);
    }

    public SBConverter removeConverter(String name) throws LockedException {
        if (this.locked) {
            throw new LockedException("The SBMapper is already locked.");
        }
        return this.mapConverter.remove(name);
    }

    public Iterator<String> keyIterator() {
        return this.mapConverter.keySet().iterator();
    }

    public int getLength() {
        if (this.locked) {
            return this.lockedLength;
        }
        int length = 0;
        Iterator<String> i = this.keyIterator();
        while (i.hasNext()) {
            String currKey = i.next();
            SBConverter conv = this.mapConverter.get(currKey);
            length += conv.getLength();
        }
        return length;
    }

    public void lock() {
        this.lockedLength = this.getLength();
        this.locked = true;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public StringBuffer getEmptyBuffer() throws InvalidObjectException {
        if (!this.locked) {
            throw new InvalidObjectException("To use this method you have to lock the SBMapper.");
        }
        StringBuffer sb = new StringBuffer(this.getLength());
        sb.setLength(this.getLength());
        return sb;
    }

    public void setObject(String name, StringBuffer sb, Object obj) throws InvalidObjectException {
        if (!this.locked) {
            throw new InvalidObjectException("To use this method you have to lock the SBMapper.");
        }
        int start = this.getStart(name);
        SBConverter conv = this.mapConverter.get(name);
        conv.setObject(sb, start, obj);
    }

    public Object getObject(String name, StringBuffer sb) throws InvalidObjectException {
        if (!this.locked) {
            throw new InvalidObjectException("To use this method you have to lock the SBMapper.");
        }
        int start = this.getStart(name);
        SBConverter conv = this.mapConverter.get(name);
        Object obj = conv.getObject(sb, start);
        return obj;
    }

    private int getStart(String name) throws InvalidObjectException {
        int length = 0;
        Iterator<String> i = this.keyIterator();
        while (i.hasNext()) {
            String convname = i.next();
            if (convname.equals(name)) {
                return length;
            }
            SBConverter conv = this.mapConverter.get(convname);
            length += conv.getLength();
        }
        throw new InvalidObjectException("The given name is not in the SBMapper");
    }
}

