/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.sbconv;

import de.riwagis.sbconv.BooleanConverter;
import de.riwagis.sbconv.ColorConverter;
import de.riwagis.sbconv.DoubleConverter;
import de.riwagis.sbconv.FloatConverter;
import de.riwagis.sbconv.FontConverter;
import de.riwagis.sbconv.IntegerConverter;
import de.riwagis.sbconv.LongConverter;
import de.riwagis.sbconv.SBConverter;
import de.riwagis.sbconv.StringBufferConverter;
import de.riwagis.sbconv.StringConverter;
import java.util.ArrayList;
import java.util.List;

public class SBConverterFactory {
    public static final int BOOLEAN = 0;
    public static final int INTEGER = 1;
    public static final int LONG = 2;
    public static final int FLOAT = 3;
    public static final int DOUBLE = 4;
    public static final int STRING_100 = 5;
    public static final int STRING_500 = 6;
    public static final int STRING_1000 = 7;
    public static final int STRING_2000 = 8;
    public static final int STRINGBUFFER_100 = 9;
    public static final int STRINGBUFFER_500 = 10;
    public static final int STRINGBUFFER_1000 = 11;
    public static final int STRINGBUFFER_2000 = 12;
    public static final int COLOR = 13;
    public static final int FONT = 14;
    private static final SBConverter[] arrConv = new SBConverter[15];
    private static final List<SBConverter> lstCustomConverters;

    private SBConverterFactory() {
    }

    public static SBConverter getConverter(int intType) {
        return arrConv[intType];
    }

    public static void registerCustomConverter(SBConverter sbConv) {
        if (lstCustomConverters.contains(sbConv)) {
            return;
        }
        lstCustomConverters.add(sbConv);
    }

    public static SBConverter getCustomConverter(Class convClass) {
        for (SBConverter conv : lstCustomConverters) {
            if (conv.getConverterClass() != convClass) continue;
            return conv;
        }
        return null;
    }

    static {
        SBConverterFactory.arrConv[0] = new BooleanConverter();
        SBConverterFactory.arrConv[1] = new IntegerConverter();
        SBConverterFactory.arrConv[2] = new LongConverter();
        SBConverterFactory.arrConv[3] = new FloatConverter();
        SBConverterFactory.arrConv[4] = new DoubleConverter();
        SBConverterFactory.arrConv[5] = new StringConverter(100);
        SBConverterFactory.arrConv[6] = new StringConverter(500);
        SBConverterFactory.arrConv[7] = new StringConverter(1000);
        SBConverterFactory.arrConv[8] = new StringConverter(2000);
        SBConverterFactory.arrConv[9] = new StringBufferConverter(100);
        SBConverterFactory.arrConv[10] = new StringBufferConverter(500);
        SBConverterFactory.arrConv[11] = new StringBufferConverter(1000);
        SBConverterFactory.arrConv[12] = new StringBufferConverter(2000);
        SBConverterFactory.arrConv[13] = new ColorConverter();
        SBConverterFactory.arrConv[14] = new FontConverter();
        lstCustomConverters = new ArrayList<SBConverter>();
    }
}

