/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.sbconv;

import de.riwagis.sbconv.InvalidObjectException;
import de.riwagis.sbconv.SBConverter;

public class IntegerConverter
implements SBConverter {
    private final int length = 12;

    IntegerConverter() {
    }

    @Override
    public int getLength() {
        return 12;
    }

    @Override
    public Object getObject(StringBuffer sb, int start) {
        String str = sb.substring(start, start + 12).trim();
        if (str.length() == 0) {
            str = "0";
        }
        return Integer.parseInt(str);
    }

    @Override
    public void setObject(StringBuffer sb, int start, Object obj) throws InvalidObjectException {
        try {
            Integer integer = (Integer)obj;
            String str = integer.toString();
            if (str.length() > 12) {
                throw new Exception("The Number is to large.");
            }
            StringBuffer sbtemp = new StringBuffer(str);
            sbtemp.setLength(12);
            sb.replace(start, start + 12, sbtemp.toString());
        }
        catch (Exception e) {
            throw new InvalidObjectException("SBConverter error: " + e.getMessage());
        }
    }

    @Override
    public Class getConverterClass() {
        return Integer.class;
    }
}

