/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.sbconv;

import de.riwagis.sbconv.InvalidObjectException;
import de.riwagis.sbconv.SBConverter;
import java.awt.Font;

public class FontConverter
implements SBConverter {
    private final int length;

    FontConverter() {
        this.length = 100;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Object getObject(StringBuffer sb, int start) {
        String[] arrParms = sb.substring(start, start + this.length).trim().split(",");
        if (arrParms.length != 3) {
            return new Font("Microsoft Sans Serif", 0, 11);
        }
        return new Font(arrParms[0], Integer.parseInt(arrParms[1]), Integer.parseInt(arrParms[2]));
    }

    @Override
    public void setObject(StringBuffer sb, int start, Object obj) throws InvalidObjectException {
        try {
            Font font = (Font)obj;
            StringBuilder sbFont = new StringBuilder();
            sbFont.append(font.getName());
            sbFont.append(",").append(font.getStyle());
            sbFont.append(",").append(font.getSize());
            sbFont.setLength(this.length);
            sb.replace(start, start + this.length, sbFont.toString());
        }
        catch (Exception e) {
            throw new InvalidObjectException("SBConverter error: " + e.getMessage());
        }
    }

    @Override
    public Class getConverterClass() {
        return Font.class;
    }
}

