/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.sbconv;

import de.riwagis.sbconv.InvalidObjectException;
import de.riwagis.sbconv.SBConverter;

public class FloatConverter
implements SBConverter {
    int length = 15;

    FloatConverter() {
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Object getObject(StringBuffer sb, int start) {
        String str = sb.substring(start, start + this.length).trim();
        if (str.length() == 0) {
            str = "0";
        }
        return Float.valueOf(Float.parseFloat(str));
    }

    @Override
    public void setObject(StringBuffer sb, int start, Object obj) throws InvalidObjectException {
        try {
            Float floatObj = (Float)obj;
            String str = floatObj.toString();
            if (str.length() > this.length) {
                throw new Exception("The Number is to large.");
            }
            StringBuffer sbtemp = new StringBuffer(str);
            sbtemp.setLength(this.length);
            sb.replace(start, start + this.length, sbtemp.toString());
        }
        catch (Exception e) {
            throw new InvalidObjectException("SBConverter error: " + e.getMessage());
        }
    }

    @Override
    public Class getConverterClass() {
        return Float.class;
    }
}

