/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.sbconv;

import de.riwagis.sbconv.InvalidObjectException;
import de.riwagis.sbconv.SBConverter;
import java.awt.Color;

public class ColorConverter
implements SBConverter {
    private final int length;

    ColorConverter() {
        this.length = 17;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Object getObject(StringBuffer sb, int start) {
        String[] arrParms = sb.substring(start, start + this.length).trim().split(",");
        if (arrParms.length != 4) {
            return Color.BLACK;
        }
        return new Color(Integer.parseInt(arrParms[0]), Integer.parseInt(arrParms[1]), Integer.parseInt(arrParms[2]), Integer.parseInt(arrParms[3]));
    }

    @Override
    public void setObject(StringBuffer sb, int start, Object obj) throws InvalidObjectException {
        try {
            Color color = (Color)obj;
            StringBuffer sbColor = new StringBuffer();
            sbColor.append(color.getRed());
            sbColor.append("," + color.getGreen());
            sbColor.append("," + color.getBlue());
            sbColor.append("," + color.getAlpha());
            sbColor.setLength(this.length);
            sb.replace(start, start + this.length, sbColor.toString());
        }
        catch (Exception e) {
            throw new InvalidObjectException("SBConverter error: " + e.getMessage());
        }
    }

    @Override
    public Class getConverterClass() {
        return Color.class;
    }
}

