/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.label;

import de.riwagis.geotools.feature.util.FeatureUtil;
import java.util.ArrayList;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;

public enum LabelFeatureAtts {
    FID("fid", Long.TYPE, true),
    FID_PARENT("fid_parent", Long.TYPE, false),
    GEOM("geom", Geometry.class, false),
    LABEL_TEXT("label_text", String.class, false),
    LABEL_DEF_ID("label_def_id", Long.TYPE, false),
    HORIZONTAL_ALIGNMENT("horizontal_alignment", String.class, true),
    VERTICAL_ALIGNMENT("vertical_alignment", String.class, true),
    ALIGNMENT("alignment", Integer.TYPE, true),
    PRE("pre", String.class, false),
    SUF("suf", String.class, false),
    ORIENTATION("orientation", Double.TYPE, false);

    private String name = null;
    private Class type = null;
    private boolean optional = false;

    private LabelFeatureAtts(String name, Class type, boolean optional) {
        this.name = name;
        this.type = type;
        this.optional = optional;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String toString() {
        return this.name;
    }

    public static String[] checkStructure(SimpleFeatureType fType) {
        try {
            ArrayList<Object> lstError = new ArrayList<Object>();
            for (LabelFeatureAtts att : LabelFeatureAtts.values()) {
                if (att.isOptional() || FeatureUtil.hasAttributeDescriptor(fType, att.getName())) continue;
                lstError.add(att.getName());
            }
            if (!(FeatureUtil.hasAttributeDescriptor(fType, ALIGNMENT.getName()) || FeatureUtil.hasAttributeDescriptor(fType, HORIZONTAL_ALIGNMENT.getName()) && FeatureUtil.hasAttributeDescriptor(fType, VERTICAL_ALIGNMENT.getName()))) {
                lstError.add(ALIGNMENT.getName() + " (" + HORIZONTAL_ALIGNMENT.getName() + ", " + VERTICAL_ALIGNMENT.getName() + ")");
            }
            if (lstError.isEmpty()) {
                return null;
            }
            return lstError.toArray(new String[0]);
        }
        catch (Exception e) {
            return new String[]{e.getMessage()};
        }
    }
}

