/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.label;

import de.riwagis.geotools.feature.util.FeatureUtil;
import org.apache.commons.lang3.StringUtils;
import org.opengis.feature.simple.SimpleFeature;

public class LabelDefInfo {
    public static final String RIWA_LABEL_DEF = "riwa_label_def";
    public static final String FID = "fid";
    public static final String PREFIX = "prefix";
    public static final String SUFFIX = "suffix";
    public static final String OVERWRITE_LABEL_TEXT_WITH_NULL = "overwrite_label_text_with_null";
    public static final String BEANSHELL = "beanshell";
    public static final String EXAMPLE = "example";
    public static final String LABEL_NAME = "label_name";
    public static final String LABEL_ORDER = "label_order";
    public static final String ACTIVE = "active";
    public static final String LABEL_TABLE = "label_table";
    public static final String LABEL_TEXT_TABLE = "label_text_table";
    public static final String LABEL_TEXT_TABLE_ATTS = "label_text_table_atts";
    public static final String LABEL_TEXT_FK = "label_text_fk";
    public static final String LABEL_GEOM_TABLE = "label_geom_table";
    public static final String LABEL_GEOM_ATTS = "label_geom_atts";
    public static final String LABEL_GEOM_FK = "label_geom_fk";
    public static final String FEATURE_TABLE = "feature_table";
    public static final String FEATURE_TABLE_ORI = "feature_table_ori";
    public static final String TEXTPOS = "textpos";
    public static final String ORIENTATION = "orientation";
    public static final String RELATIVE_ORI = "relative_ori";
    public static final String ORI_IN_GON = "ori_in_gon";
    public static final String RELATIVE_POS = "relative_pos";
    public static final String OFFSET_X = "offset_x";
    public static final String OFFSET_Y = "offset_y";
    public static final String TEXT_READABLE_ON_LAYOUT = "text_readable_on_layout";
    public static final String AUTO_PLACE = "auto_place";
    public static final String UPDATE_TEXT = "update_text";
    public static final String USER_SELECTS_POSITION = "user_selects_position";
    private final int fid;
    private final String label_order;
    private final String label_name;
    private final String example;
    private final String beanshell;
    private final String prefix;
    private final String suffix;
    private final boolean active;
    private final String label_table;
    private final String label_text_table;
    private final String label_text_table_atts;
    private final String label_text_fk;
    private final String label_geom_table;
    private final String label_geom_atts;
    private final String label_geom_fk;
    private final String feature_table;
    private final String feature_table_ori;
    private final boolean overwrite_label_text_with_null;
    private final int textpos;
    private final double orientation;
    private final boolean relative_ori;
    private final boolean ori_in_gon;
    private final boolean relative_pos;
    private final double offset_x;
    private final double offset_y;
    private final boolean user_selects_position;
    private final boolean text_readable_on_layout;
    private final boolean auto_place;
    private final boolean update_text;

    public LabelDefInfo(int fid, String label_order, String label_name, String example, String beanshell, String prefix, String suffix, Boolean active, String feature_table, String feature_table_ori, String label_table, String label_text_table, String label_text_table_atts, String label_text_fk, String label_geom_table, String label_geom_atts, String label_geom_fk, Boolean overwrite_label_text_with_null, Integer textpos, Double orientation, Boolean relative_ori, Boolean ori_in_gon, Boolean relative_pos, Double offset_x, Double offset_y, Boolean user_selects_position, Boolean text_readable_on_layout, Boolean auto_place, Boolean update_text) {
        this.fid = fid;
        this.label_order = label_order;
        this.label_name = StringUtils.isBlank((CharSequence)label_name) ? "label_" + fid : label_name;
        this.example = (String)StringUtils.defaultIfEmpty((CharSequence)example, (CharSequence)"");
        this.beanshell = beanshell;
        this.prefix = (String)StringUtils.defaultIfEmpty((CharSequence)prefix, (CharSequence)"");
        this.suffix = (String)StringUtils.defaultIfEmpty((CharSequence)suffix, (CharSequence)"");
        this.active = active == null ? true : active;
        this.feature_table = feature_table;
        this.feature_table_ori = StringUtils.isBlank((CharSequence)feature_table_ori) ? ORIENTATION : feature_table_ori;
        this.label_table = StringUtils.isBlank((CharSequence)label_table) ? (LabelDefInfo.isInUpperCase(feature_table) ? feature_table + "_TBL" : feature_table + "_tbl") : label_table;
        this.label_text_table = StringUtils.isBlank((CharSequence)label_text_table) ? feature_table : label_text_table;
        this.label_text_table_atts = label_text_table_atts;
        this.label_text_fk = StringUtils.isBlank((CharSequence)label_text_fk) ? FID : label_text_fk;
        this.label_geom_table = StringUtils.isBlank((CharSequence)label_geom_table) ? feature_table : label_geom_table;
        this.label_geom_atts = label_geom_atts;
        this.label_geom_fk = StringUtils.isBlank((CharSequence)label_geom_fk) ? FID : label_geom_fk;
        this.overwrite_label_text_with_null = overwrite_label_text_with_null == null ? false : overwrite_label_text_with_null;
        this.textpos = textpos == null ? 1 : textpos;
        this.orientation = orientation == null ? 0.0 : orientation;
        this.relative_ori = relative_ori == null ? true : relative_ori;
        this.ori_in_gon = ori_in_gon == null ? false : ori_in_gon;
        this.relative_pos = relative_pos == null ? true : relative_pos;
        this.offset_x = offset_x == null ? 0.0 : offset_x;
        this.offset_y = offset_y == null ? 0.0 : offset_y;
        this.user_selects_position = user_selects_position == null ? false : user_selects_position;
        this.text_readable_on_layout = text_readable_on_layout == null ? true : text_readable_on_layout;
        this.auto_place = auto_place == null ? false : auto_place;
        this.update_text = update_text == null ? true : update_text;
    }

    public LabelDefInfo(SimpleFeature labelDefFeature) {
        this(Integer.parseInt(FeatureUtil.getFeatureIDWithoutTable(labelDefFeature)), (String)FeatureUtil.getAttribute(labelDefFeature, LABEL_ORDER), (String)FeatureUtil.getAttribute(labelDefFeature, LABEL_NAME), (String)FeatureUtil.getAttribute(labelDefFeature, EXAMPLE), (String)FeatureUtil.getAttribute(labelDefFeature, BEANSHELL), (String)FeatureUtil.getAttribute(labelDefFeature, PREFIX), (String)FeatureUtil.getAttribute(labelDefFeature, SUFFIX), LabelDefInfo.objectToBoolean(FeatureUtil.getAttribute(labelDefFeature, ACTIVE)), (String)FeatureUtil.getAttribute(labelDefFeature, FEATURE_TABLE), (String)FeatureUtil.getAttribute(labelDefFeature, FEATURE_TABLE_ORI), (String)FeatureUtil.getAttribute(labelDefFeature, LABEL_TABLE), (String)FeatureUtil.getAttribute(labelDefFeature, LABEL_TEXT_TABLE), (String)FeatureUtil.getAttribute(labelDefFeature, LABEL_TEXT_TABLE_ATTS), (String)FeatureUtil.getAttribute(labelDefFeature, LABEL_TEXT_FK), (String)FeatureUtil.getAttribute(labelDefFeature, LABEL_GEOM_TABLE), (String)FeatureUtil.getAttribute(labelDefFeature, LABEL_GEOM_ATTS), (String)FeatureUtil.getAttribute(labelDefFeature, LABEL_GEOM_FK), LabelDefInfo.objectToBoolean(FeatureUtil.getAttribute(labelDefFeature, OVERWRITE_LABEL_TEXT_WITH_NULL)), LabelDefInfo.objectToInteger(FeatureUtil.getAttribute(labelDefFeature, TEXTPOS)), LabelDefInfo.objectToDouble(FeatureUtil.getAttribute(labelDefFeature, ORIENTATION)), LabelDefInfo.objectToBoolean(FeatureUtil.getAttribute(labelDefFeature, RELATIVE_ORI)), LabelDefInfo.objectToBoolean(FeatureUtil.getAttribute(labelDefFeature, ORI_IN_GON)), LabelDefInfo.objectToBoolean(FeatureUtil.getAttribute(labelDefFeature, RELATIVE_POS)), LabelDefInfo.objectToDouble(FeatureUtil.getAttribute(labelDefFeature, OFFSET_X)), LabelDefInfo.objectToDouble(FeatureUtil.getAttribute(labelDefFeature, OFFSET_Y)), LabelDefInfo.objectToBoolean(FeatureUtil.getAttribute(labelDefFeature, USER_SELECTS_POSITION)), LabelDefInfo.objectToBoolean(FeatureUtil.getAttribute(labelDefFeature, TEXT_READABLE_ON_LAYOUT)), LabelDefInfo.objectToBoolean(FeatureUtil.getAttribute(labelDefFeature, AUTO_PLACE)), LabelDefInfo.objectToBoolean(FeatureUtil.getAttribute(labelDefFeature, UPDATE_TEXT)));
    }

    public String toString() {
        return "FID: " + this.getFid() + ", label_name: " + (String)StringUtils.defaultIfBlank((CharSequence)this.getLabel_name(), (CharSequence)"");
    }

    public static Integer objectToInteger(Object objToConvert) {
        if (objToConvert == null) {
            return null;
        }
        if (objToConvert instanceof Number) {
            return ((Number)objToConvert).intValue();
        }
        throw new IllegalArgumentException(String.format("Given object '%s' can not be converted to an Integer.", objToConvert));
    }

    public static Double objectToDouble(Object objToConvert) {
        if (objToConvert == null) {
            return null;
        }
        if (objToConvert instanceof Number) {
            return ((Number)objToConvert).doubleValue();
        }
        throw new IllegalArgumentException(String.format("Given object '%s' can not be converted to an Double.", objToConvert));
    }

    public static Boolean objectToBoolean(Object objToConvert) {
        if (objToConvert == null) {
            return null;
        }
        if (objToConvert instanceof Boolean) {
            return (Boolean)objToConvert;
        }
        if (objToConvert instanceof Number) {
            return ((Number)objToConvert).intValue() != 0;
        }
        if (objToConvert.toString().equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public int getFid() {
        return this.fid;
    }

    public String getLabel_order() {
        return this.label_order;
    }

    public String getLabel_name() {
        return this.label_name;
    }

    public String getExample() {
        return this.example;
    }

    public String getBeanshell() {
        return this.beanshell;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getLabel_table() {
        return this.label_table;
    }

    public String getLabel_text_table() {
        return this.label_text_table;
    }

    public String getLabel_text_table_atts() {
        return this.label_text_table_atts;
    }

    public String getLabel_text_fk() {
        return this.label_text_fk;
    }

    public String getLabel_geom_table() {
        return this.label_geom_table;
    }

    public String getLabel_geom_atts() {
        return this.label_geom_atts;
    }

    public String getLabel_geom_fk() {
        return this.label_geom_fk;
    }

    public String getFeature_table() {
        return this.feature_table;
    }

    public String getFeature_table_ori() {
        return this.feature_table_ori;
    }

    public boolean isOverwrite_label_text_with_null() {
        return this.overwrite_label_text_with_null;
    }

    public int getTextpos() {
        return this.textpos;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public boolean isRelative_ori() {
        return this.relative_ori;
    }

    public boolean isOri_in_gon() {
        return this.ori_in_gon;
    }

    public boolean isRelative_pos() {
        return this.relative_pos;
    }

    public double getOffset_x() {
        return this.offset_x;
    }

    public double getOffset_y() {
        return this.offset_y;
    }

    public boolean isUser_selects_position() {
        return this.user_selects_position;
    }

    public boolean isText_readable_on_layout() {
        return this.text_readable_on_layout;
    }

    public boolean isAuto_place() {
        return this.auto_place;
    }

    public boolean isUpdate_text() {
        return this.update_text;
    }

    private static boolean isInUpperCase(String textToCheck) {
        return textToCheck.equals(textToCheck.toUpperCase());
    }
}

