/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.label;

import de.riwagis.geotools.feature.bsh.FeatBshObjectBuilder;
import de.riwagis.geotools.feature.util.FeatureTypeUtil;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.label.LabelDefInfo;
import de.riwagis.label.LabelFeatureAction;
import de.riwagis.label.LabelFeatureAtts;
import de.riwagis.util.construction.ConstSupport;
import de.riwagis.util.jts.CoordinateArraySupport;
import de.riwagis.util.jts.InteriorPointFinder;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class AbstractCRUDLabelsUtil {
    private static final String LEFT = "Left";
    private static final String CENTER = "Center";
    private static final String RIGHT = "Right";
    private static final String TOP = "Top";
    private static final String HALFLINE = "Halfline";
    private static final String BASELINE = "Baseline";

    public String createLabelText(LabelDefInfo labelDef, SimpleFeature parentFeature) throws Exception {
        String strBeanshell = labelDef.getBeanshell();
        if (StringUtils.isNotEmpty((CharSequence)strBeanshell)) {
            FeatBshObjectBuilder objBuilder = FeatBshObjectBuilder.getInstance(strBeanshell);
            String labelTextTableName = labelDef.getLabel_text_table();
            if (StringUtils.equalsIgnoreCase((CharSequence)labelTextTableName, (CharSequence)labelDef.getFeature_table())) {
                objBuilder.setFeature(parentFeature);
            } else {
                String fid4Filter = FeatureUtil.getFeatureIDWithoutTable(parentFeature);
                SimpleFeature labelTextTableFeature = this.retrieveLinkedFeature(labelTextTableName, labelDef.getLabel_text_table_atts(), labelDef.getLabel_text_fk(), fid4Filter);
                if (labelTextTableFeature == null) {
                    throw new IllegalStateException(String.format("No feature for labeling found : '%s'.'%s' filter '%s'.", labelTextTableName, labelDef.getLabel_text_fk(), Objects.toString(fid4Filter, null)));
                }
                objBuilder.setFeature(labelTextTableFeature);
            }
            return Objects.toString(objBuilder.getObject(), null);
        }
        return null;
    }

    public LabelFeatureAction updateLabelText(LabelDefInfo labelDef, SimpleFeature parentFeature, SimpleFeature labelFeature2Update) throws Exception {
        String strLabelText = this.createLabelText(labelDef, parentFeature);
        if (StringUtils.isEmpty((CharSequence)strLabelText) && !labelDef.isOverwrite_label_text_with_null()) {
            return LabelFeatureAction.DELETE;
        }
        boolean modified = false;
        SimpleFeatureType labelSchema = this.retrieveLabelSchema(labelDef.getLabel_table());
        String strOldLabelText = Objects.toString(FeatureUtil.getAttribute(labelFeature2Update, FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.LABEL_TEXT.getName())), null);
        if (!StringUtils.equals((CharSequence)strLabelText, (CharSequence)strOldLabelText)) {
            FeatureUtil.setAttribute(labelFeature2Update, FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.LABEL_TEXT.getName()), strLabelText);
            modified = true;
        }
        String strOldPrefix = Objects.toString(FeatureUtil.getAttribute(labelFeature2Update, FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.PRE.getName())), null);
        String strPrefix = labelDef.getPrefix();
        if (!StringUtils.equals((CharSequence)strPrefix, (CharSequence)strOldPrefix)) {
            FeatureUtil.setAttribute(labelFeature2Update, FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.PRE.getName()), strPrefix);
            modified = true;
        }
        String strOldSuffix = Objects.toString(FeatureUtil.getAttribute(labelFeature2Update, FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.SUF.getName())), null);
        String strSuffix = labelDef.getSuffix();
        if (!StringUtils.equals((CharSequence)strSuffix, (CharSequence)strOldSuffix)) {
            FeatureUtil.setAttribute(labelFeature2Update, FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.SUF.getName()), strSuffix);
            modified = true;
        }
        return modified ? LabelFeatureAction.UPDATE : LabelFeatureAction.NONE;
    }

    public SimpleFeature createLabel(LabelDefInfo labelDef, SimpleFeature parentFeature) throws Exception {
        SimpleFeatureBuilder sfb;
        SimpleFeatureType labelSchema = this.retrieveLabelSchema(labelDef.getLabel_table());
        if (!this.setupLabelText(labelDef, labelSchema, sfb = new SimpleFeatureBuilder(labelSchema), parentFeature)) {
            return null;
        }
        String strLabelDefID = Integer.toString(labelDef.getFid());
        String parentFeatureFID = FeatureUtil.getFeatureIDWithoutTable(parentFeature);
        sfb.set(FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.LABEL_DEF_ID.getName()), (Object)strLabelDefID);
        sfb.set(FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.FID_PARENT.getName()), (Object)parentFeatureFID);
        this.setupTextAlignment(labelDef, labelSchema, sfb);
        Geometry sourceGeometry = this.getSourceGeometry(labelDef, parentFeature);
        if (sourceGeometry != null) {
            Geometry nearestGeometry = this.findNearestGeometry(sourceGeometry);
            Geometry finalGeometry = this.getGeometry(labelDef, parentFeature, nearestGeometry);
            double orientation = this.getOrientation(labelDef, parentFeature, nearestGeometry);
            sfb.set(FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.GEOM.getName()), (Object)finalGeometry);
            sfb.set(FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.ORIENTATION.getName()), (Object)orientation);
        } else {
            sfb.set(FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.ORIENTATION.getName()), (Object)0.0);
        }
        return sfb.buildFeature(null);
    }

    public void updateLabelGeometry(LabelDefInfo labelDef, SimpleFeature parentFeature, SimpleFeature labelFeature) throws Exception {
        Objects.requireNonNull(parentFeature);
        Objects.requireNonNull(labelFeature);
        Geometry sourceGeometry = this.getSourceGeometry(labelDef, parentFeature);
        if (sourceGeometry != null) {
            Geometry nearestGeometry = this.findNearestGeometry(sourceGeometry);
            Geometry finalGeometry = this.getGeometry(labelDef, parentFeature, nearestGeometry);
            double orientation = this.getOrientation(labelDef, parentFeature, nearestGeometry);
            labelFeature.setAttribute(LabelFeatureAtts.GEOM.getName(), (Object)finalGeometry);
            labelFeature.setAttribute(LabelFeatureAtts.ORIENTATION.getName(), (Object)orientation);
        }
    }

    protected abstract LabelDefInfo retrieveLabelInfoForID(int var1) throws Exception;

    protected abstract SimpleFeature retrieveLinkedFeature(String var1, String var2, String var3, String var4) throws Exception;

    protected abstract SimpleFeatureType retrieveLabelSchema(String var1) throws Exception;

    private double oriInDegree(double oriInGon) {
        return ConstSupport.getPositiveOrientation((double)(-oriInGon), (int)1) * 0.9;
    }

    private double oriInGon(double oriInDegree) {
        return ConstSupport.getPositiveOrientation((double)(-oriInDegree), (int)0) / 0.9;
    }

    private boolean setupLabelText(LabelDefInfo labelDef, SimpleFeatureType labelSchema, SimpleFeatureBuilder sfb, SimpleFeature parentFeature) throws Exception {
        String strLabelText = this.createLabelText(labelDef, parentFeature);
        if (StringUtils.isEmpty((CharSequence)strLabelText) && !labelDef.isOverwrite_label_text_with_null()) {
            return false;
        }
        sfb.set(FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.PRE.getName()), (Object)labelDef.getPrefix());
        sfb.set(FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.SUF.getName()), (Object)labelDef.getSuffix());
        sfb.set(FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.LABEL_TEXT.getName()), (Object)strLabelText);
        return true;
    }

    private Geometry getSourceGeometry(LabelDefInfo labelDef, SimpleFeature parentFeature) throws Exception {
        String labelGeomTableName = labelDef.getLabel_geom_table();
        if (StringUtils.equalsIgnoreCase((CharSequence)labelGeomTableName, (CharSequence)labelDef.getFeature_table())) {
            return (Geometry)parentFeature.getDefaultGeometry();
        }
        String fid4Filter = FeatureUtil.getFeatureIDWithoutTable(parentFeature);
        SimpleFeature labelGeomFeature = this.retrieveLinkedFeature(labelGeomTableName, labelDef.getLabel_geom_atts(), labelDef.getLabel_geom_fk(), fid4Filter);
        if (labelGeomFeature == null) {
            throw new IllegalStateException(String.format("No feature for labels geometry found : '%s'.'%s' filter '%s'.", labelGeomTableName, labelDef.getLabel_geom_fk(), Objects.toString(fid4Filter, null)));
        }
        return (Geometry)labelGeomFeature.getDefaultGeometry();
    }

    private double getOrientationFromFeature(LabelDefInfo labelDef, SimpleFeature parentFeature) {
        double dblOriDegree = 0.0;
        String strOriCol = labelDef.getFeature_table_ori();
        Number nbrOri = (Number)FeatureUtil.getAttribute(parentFeature, strOriCol);
        if (nbrOri != null) {
            dblOriDegree = labelDef.isOri_in_gon() ? this.oriInDegree(nbrOri.doubleValue()) : nbrOri.doubleValue();
        }
        return dblOriDegree;
    }

    private Geometry getGeometry(LabelDefInfo labelDef, SimpleFeature parentFeature, Geometry sourceGeometry) {
        boolean relativePos = labelDef.isRelative_pos();
        double dblOriDegree = this.getOrientationFromFeature(labelDef, parentFeature);
        double offsetX = labelDef.getOffset_x();
        double offsetY = labelDef.getOffset_y();
        if (sourceGeometry.getClass().isAssignableFrom(Point.class)) {
            return this.createGeometryFromPoint(sourceGeometry, relativePos, dblOriDegree, offsetX, offsetY);
        }
        if (sourceGeometry.getClass().isAssignableFrom(LineString.class)) {
            LineSegment longestSegment = this.longestSegment(sourceGeometry);
            double fullAngle = this.getFullAngle(labelDef, longestSegment);
            return this.createGeometryFromLineString(relativePos, offsetX, offsetY, longestSegment, fullAngle);
        }
        if (sourceGeometry.getClass().isAssignableFrom(Polygon.class)) {
            return this.createGeometryFromPolygon(sourceGeometry, offsetX, offsetY);
        }
        throw new IllegalStateException("Unsupported Geometry Type.");
    }

    private double getOrientation(LabelDefInfo labelDef, SimpleFeature parentFeature, Geometry finalGeometry) {
        boolean orientationUsesGon = labelDef.isOri_in_gon();
        boolean relativeOri = labelDef.isRelative_ori();
        double dblOriDegree = this.getOrientationFromFeature(labelDef, parentFeature);
        if (finalGeometry.getClass().isAssignableFrom(LineString.class)) {
            LineSegment longestSegment = this.longestSegment(finalGeometry);
            double fullAngle = this.getFullAngle(labelDef, longestSegment);
            dblOriDegree = orientationUsesGon ? Math.toDegrees(fullAngle) - 90.0 : Math.toDegrees(fullAngle);
        } else if (finalGeometry.getClass().isAssignableFrom(Polygon.class)) {
            relativeOri = false;
        }
        double dblOriLabel = this.getLabelOrientation(labelDef, orientationUsesGon, relativeOri, dblOriDegree);
        if (orientationUsesGon) {
            return this.oriInGon(dblOriLabel);
        }
        return dblOriLabel;
    }

    private double getFullAngle(LabelDefInfo labelDef, LineSegment longestSegment) {
        if (labelDef.isText_readable_on_layout()) {
            return this.angle(longestSegment);
        }
        return Angle.angle((Coordinate)longestSegment.p0, (Coordinate)longestSegment.p1);
    }

    private double getLabelOrientation(LabelDefInfo labelDef, boolean orientationUsesGon, boolean relativeOri, double dblOriDegree) {
        double dblOriLabelDef = orientationUsesGon ? this.oriInDegree(labelDef.getOrientation()) : labelDef.getOrientation();
        double dblOriLabel = relativeOri ? ConstSupport.getPositiveOrientation((double)(dblOriDegree + dblOriLabelDef), (int)0) : dblOriLabelDef;
        if (labelDef.isText_readable_on_layout()) {
            if (orientationUsesGon) {
                if (dblOriLabel > 0.0 && dblOriLabel < 180.0) {
                    dblOriLabel -= 180.0;
                } else if (dblOriLabel < -180.0 && dblOriLabel >= -360.0) {
                    dblOriLabel += 180.0;
                }
            } else if (dblOriLabel > 90.0 && dblOriLabel < 270.0) {
                dblOriLabel -= 180.0;
            } else if (dblOriLabel < -90.0 && dblOriLabel > -270.0) {
                dblOriLabel += 180.0;
            }
        }
        if (dblOriLabel < 0.0) {
            dblOriLabel += 360.0;
        } else if (dblOriLabel >= 360.0) {
            dblOriLabel -= 360.0;
        }
        return dblOriLabel;
    }

    private Geometry createGeometryFromLineString(boolean relativePos, double offsetX, double offsetY, LineSegment longestSegment, double fullAngle) {
        Point geom = new GeometryFactory().createPoint(this.average(longestSegment.p0, longestSegment.p1));
        if (relativePos) {
            geom.apply(coordinate -> {
                double cosAngle = Math.cos(0.0 - fullAngle);
                double sinAngle = Math.sin(0.0 - fullAngle);
                double x = offsetX;
                double y = offsetY;
                coordinate.x = coordinate.x + x * cosAngle + y * sinAngle;
                coordinate.y = coordinate.y + y * cosAngle - x * sinAngle;
            });
        } else {
            geom.apply(coord -> {
                coord.x += offsetX;
                coord.y += offsetY;
            });
        }
        return geom;
    }

    private Geometry createGeometryFromPolygon(Geometry geom, double offsetX, double offsetY) {
        InteriorPointFinder interiorPointFinder = new InteriorPointFinder();
        geom = new GeometryFactory().createPoint(interiorPointFinder.findPoint(geom));
        geom.apply(coord -> {
            coord.x += offsetX;
            coord.y += offsetY;
        });
        return geom;
    }

    private Geometry createGeometryFromPoint(Geometry geom, boolean relativePos, double dblOriDegree, double offsetX, double offsetY) {
        geom = new GeometryFactory().createPoint(new Coordinate(geom.getCoordinate()));
        if (relativePos) {
            double fullAngle = Math.toRadians(dblOriDegree);
            geom.apply(coordinate -> {
                double cosAngle = Math.cos(0.0 - fullAngle);
                double sinAngle = Math.sin(0.0 - fullAngle);
                double x = offsetX;
                double y = offsetY;
                coordinate.x = coordinate.x + x * cosAngle + y * sinAngle;
                coordinate.y = coordinate.y + y * cosAngle - x * sinAngle;
            });
        } else {
            geom.apply(coord -> {
                coord.x += offsetX;
                coord.y += offsetY;
            });
        }
        return geom;
    }

    private Geometry findNearestGeometry(Geometry geom) {
        if (geom instanceof GeometryCollection) {
            Geometry lastFound = null;
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                Geometry test = geom.getGeometryN(i);
                if (test instanceof Point) {
                    lastFound = test;
                    break;
                }
                if (test instanceof LineString && (lastFound == null || lastFound instanceof Polygon)) {
                    lastFound = test;
                }
                if (!(test instanceof Polygon) || lastFound != null) continue;
                lastFound = test;
            }
            if (lastFound != null) {
                geom = lastFound;
            }
        }
        return geom;
    }

    private void setupTextAlignment(LabelDefInfo labelDef, SimpleFeatureType labelSchema, SimpleFeatureBuilder sfb) {
        int textPos = labelDef.getTextpos();
        if (FeatureTypeUtil.hasSchemaAttribute(labelSchema, LabelFeatureAtts.ALIGNMENT.getName())) {
            sfb.set(FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.ALIGNMENT.getName()), (Object)textPos);
        } else {
            String strHorizontalAlignment;
            String strVerticalAlignment = switch (textPos) {
                case 1 -> {
                    strHorizontalAlignment = LEFT;
                    yield TOP;
                }
                case 2 -> {
                    strHorizontalAlignment = CENTER;
                    yield TOP;
                }
                case 3 -> {
                    strHorizontalAlignment = RIGHT;
                    yield TOP;
                }
                case 4 -> {
                    strHorizontalAlignment = LEFT;
                    yield HALFLINE;
                }
                case 5 -> {
                    strHorizontalAlignment = CENTER;
                    yield HALFLINE;
                }
                case 6 -> {
                    strHorizontalAlignment = RIGHT;
                    yield HALFLINE;
                }
                case 7 -> {
                    strHorizontalAlignment = LEFT;
                    yield BASELINE;
                }
                case 8 -> {
                    strHorizontalAlignment = CENTER;
                    yield BASELINE;
                }
                case 9 -> {
                    strHorizontalAlignment = RIGHT;
                    yield BASELINE;
                }
                default -> {
                    strHorizontalAlignment = CENTER;
                    yield HALFLINE;
                }
            };
            sfb.set(FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.HORIZONTAL_ALIGNMENT.getName()), (Object)strHorizontalAlignment);
            sfb.set(FeatureTypeUtil.getSchemaAttribute(labelSchema, LabelFeatureAtts.VERTICAL_ALIGNMENT.getName()), (Object)strVerticalAlignment);
        }
    }

    private double angle(LineSegment segment) {
        double angle = Angle.angle((Coordinate)segment.p0, (Coordinate)segment.p1);
        if (angle < -1.5707963267948966) {
            angle += Math.PI;
        }
        if (angle > 1.5707963267948966) {
            angle -= Math.PI;
        }
        return angle;
    }

    private LineSegment longestSegment(Geometry geometry) {
        double maxSegmentLength = -1.0;
        Coordinate c0 = null;
        Coordinate c1 = null;
        Collection arrays = CoordinateArraySupport.toCoordinateArrays((Geometry)geometry, (boolean)false);
        for (Coordinate[] coordinates : arrays) {
            for (int j = 1; j < coordinates.length; ++j) {
                if (!(coordinates[j - 1].distance(coordinates[j]) > maxSegmentLength)) continue;
                maxSegmentLength = coordinates[j - 1].distance(coordinates[j]);
                c0 = coordinates[j - 1];
                c1 = coordinates[j];
            }
        }
        return new LineSegment(c0, c1);
    }

    private Coordinate average(Coordinate c1, Coordinate c2) {
        return new Coordinate(this.avg(c1.x, c2.x), this.avg(c1.y, c2.y), c1.getZ());
    }

    private double avg(double a, double b) {
        return (a + b) / 2.0;
    }
}

