/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.VolatileFunction;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.GmlObjectId;
import org.opengis.filter.identity.Identifier;

public class OptimizedSimplifyingFilterVisitor
extends DuplicatingFilterVisitor {
    public static final SimplifyingFilterVisitor.FIDValidator ANY_FID_VALID = fid -> true;
    FilterAttributeExtractor attributeExtractor = new FilterAttributeExtractor();
    protected FeatureType featureType;
    private SimplifyingFilterVisitor.FIDValidator fidValidator = ANY_FID_VALID;

    public void setFeatureType(FeatureType featureType) {
        this.featureType = featureType;
    }

    public Object visit(And filter, Object extraData) {
        List<Filter> filters = this.collect(filter, And.class, extraData, new ArrayList<Filter>());
        filters = this.basicAndSimplification(filters);
        if ((filters = this.extraAndSimplification(extraData, filters)).size() == 0) {
            return Filter.INCLUDE;
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return this.getFactory(extraData).and(filters);
    }

    protected List<Filter> basicAndSimplification(List<Filter> filters) {
        ArrayList<Filter> simplified = new ArrayList<Filter>(filters.size());
        for (Filter child : filters) {
            if (child == Filter.EXCLUDE) {
                return Arrays.asList(Filter.EXCLUDE);
            }
            if (child == Filter.INCLUDE) continue;
            simplified.add(child);
        }
        this.deleteDuplicates(simplified);
        if (this.checkForOppositeFilters(simplified)) {
            return Arrays.asList(Filter.EXCLUDE);
        }
        return simplified;
    }

    private boolean checkForOppositeFilters(List<Filter> simplified) {
        for (int i = 0; i < simplified.size(); ++i) {
            for (int j = i + 1; j < simplified.size(); ++j) {
                Filter f2;
                Filter f1 = simplified.get(i);
                if (!this.dualFilters(f1, f2 = simplified.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    private void deleteDuplicates(List<Filter> filters) {
        HashMap<Filter, List> uniqueFilters = new HashMap<Filter, List>();
        Iterator<Filter> iterator = filters.iterator();
        while (iterator.hasNext()) {
            Filter next = iterator.next();
            List fx = uniqueFilters.computeIfAbsent(next, f -> new ArrayList());
            boolean addItem = true;
            if (!fx.isEmpty()) {
                for (Filter fxs : fx) {
                    if (!fxs.equals(next)) continue;
                    iterator.remove();
                    addItem = false;
                    break;
                }
            }
            if (!addItem) continue;
            fx.add(next);
        }
    }

    protected <T extends BinaryLogicOperator> List<Filter> collect(T filter, Class<T> type, Object extraData, List<Filter> collected) {
        ArrayDeque stack = new ArrayDeque(filter.getChildren());
        while (!stack.isEmpty()) {
            Filter child = (Filter)stack.removeLast();
            if (type.isInstance(child)) {
                stack.addAll(((BinaryLogicOperator)child).getChildren());
                continue;
            }
            Filter cloned = (Filter)child.accept((FilterVisitor)this, extraData);
            if (type.isInstance(cloned)) {
                stack.addAll(((BinaryLogicOperator)cloned).getChildren());
                continue;
            }
            collected.add(cloned);
        }
        return collected;
    }

    private boolean dualFilters(Filter f1, Filter f2) {
        if (f1 instanceof Not) {
            Not not = (Not)f1;
            return f2.equals(not.getFilter());
        }
        if (f2 instanceof Not) {
            Not not = (Not)f2;
            return f1.equals(not.getFilter());
        }
        if (f1 instanceof PropertyIsEqualTo && f2 instanceof PropertyIsNotEqualTo || f1 instanceof PropertyIsNotEqualTo && f2 instanceof PropertyIsEqualTo) {
            PropertyIsNotEqualTo ne;
            PropertyIsEqualTo e;
            if (f2 instanceof PropertyIsEqualTo) {
                e = (PropertyIsEqualTo)f2;
                ne = (PropertyIsNotEqualTo)f1;
            } else {
                e = (PropertyIsEqualTo)f1;
                ne = (PropertyIsNotEqualTo)f2;
            }
            if (!this.isSimpleFeature()) {
                return false;
            }
            return e.getExpression1().equals(ne.getExpression1()) && e.getExpression2().equals(ne.getExpression2()) || e.getExpression2().equals(ne.getExpression1()) && e.getExpression1().equals(ne.getExpression2());
        }
        return false;
    }

    public Object visit(Or filter, Object extraData) {
        List<Filter> filters = this.collect(filter, Or.class, extraData, new ArrayList<Filter>());
        filters = this.basicOrSimplification(filters);
        if ((filters = this.extraOrSimplification(extraData, filters)).size() == 0) {
            return Filter.EXCLUDE;
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return this.getFactory(extraData).or(filters);
    }

    protected List<Filter> basicOrSimplification(List<Filter> filters) {
        ArrayList<Filter> simplified = new ArrayList<Filter>(filters.size());
        for (Filter child : filters) {
            if (child == Filter.INCLUDE) {
                return Arrays.asList(Filter.INCLUDE);
            }
            if (child == Filter.EXCLUDE) continue;
            simplified.add(child);
        }
        this.deleteDuplicates(simplified);
        if (this.checkForOppositeFilters(simplified)) {
            return Arrays.asList(Filter.INCLUDE);
        }
        return simplified;
    }

    protected List<Filter> extraAndSimplification(Object extraData, List<Filter> filters) {
        return filters;
    }

    protected List<Filter> extraOrSimplification(Object extraData, List<Filter> filters) {
        return filters;
    }

    public Object visit(Id filter, Object extraData) {
        if (filter.getIDs().size() == 0) {
            return Filter.EXCLUDE;
        }
        HashSet<Identifier> validFids = new HashSet<Identifier>();
        for (Identifier id : filter.getIdentifiers()) {
            if (!(id instanceof FeatureId) && !(id instanceof GmlObjectId) || !this.fidValidator.isValid((String)id.getID())) continue;
            validFids.add(id);
        }
        Object validIdFilter = validFids.size() == 0 ? Filter.EXCLUDE : this.getFactory(extraData).id(validFids);
        return validIdFilter;
    }

    public Object visit(Not filter, Object extraData) {
        FilterFactory2 ff = this.getFactory(extraData);
        Filter inner = filter.getFilter();
        if (inner instanceof Not) {
            Not innerNot = (Not)inner;
            return innerNot.getFilter().accept((FilterVisitor)this, extraData);
        }
        if (inner instanceof And) {
            And and = (And)inner;
            List children = and.getChildren();
            ArrayList<Filter> negatedChildren = new ArrayList<Filter>();
            for (Filter child : children) {
                negatedChildren.add((Filter)ff.not(child).accept((FilterVisitor)this, extraData));
            }
            return ff.or(negatedChildren);
        }
        if (inner instanceof Or) {
            Or or = (Or)inner;
            List children = or.getChildren();
            ArrayList<Filter> negatedChildren = new ArrayList<Filter>();
            for (Filter child : children) {
                negatedChildren.add((Filter)ff.not(child).accept((FilterVisitor)this, extraData));
            }
            return ff.and(negatedChildren);
        }
        if (this.isSimpleFeature()) {
            Filter simplified = (Filter)inner.accept((FilterVisitor)this, extraData);
            if (simplified == Filter.INCLUDE) {
                return Filter.EXCLUDE;
            }
            if (simplified == Filter.EXCLUDE) {
                return Filter.INCLUDE;
            }
            if (simplified instanceof PropertyIsBetween) {
                PropertyIsBetween pb = (PropertyIsBetween)simplified;
                PropertyIsLessThan lt = ff.less(pb.getExpression(), pb.getLowerBoundary());
                PropertyIsGreaterThan gt = ff.greater(pb.getExpression(), pb.getUpperBoundary());
                return ff.or((Filter)lt, (Filter)gt);
            }
            if (simplified instanceof PropertyIsEqualTo) {
                PropertyIsEqualTo pe = (PropertyIsEqualTo)simplified;
                return ff.notEqual(pe.getExpression1(), pe.getExpression2(), pe.isMatchingCase());
            }
            if (simplified instanceof PropertyIsNotEqualTo) {
                PropertyIsNotEqualTo pe = (PropertyIsNotEqualTo)simplified;
                return ff.equal(pe.getExpression1(), pe.getExpression2(), pe.isMatchingCase());
            }
            if (simplified instanceof PropertyIsGreaterThan) {
                PropertyIsGreaterThan pg = (PropertyIsGreaterThan)simplified;
                return ff.lessOrEqual(pg.getExpression1(), pg.getExpression2(), pg.isMatchingCase());
            }
            if (simplified instanceof PropertyIsGreaterThanOrEqualTo) {
                PropertyIsGreaterThanOrEqualTo pg = (PropertyIsGreaterThanOrEqualTo)simplified;
                return ff.less(pg.getExpression1(), pg.getExpression2(), pg.isMatchingCase());
            }
            if (simplified instanceof PropertyIsLessThan) {
                PropertyIsLessThan pl = (PropertyIsLessThan)simplified;
                return ff.greaterOrEqual(pl.getExpression1(), pl.getExpression2(), pl.isMatchingCase());
            }
            if (simplified instanceof PropertyIsLessThanOrEqualTo) {
                PropertyIsLessThanOrEqualTo pl = (PropertyIsLessThanOrEqualTo)simplified;
                return ff.greater(pl.getExpression1(), pl.getExpression2(), pl.isMatchingCase());
            }
        }
        return super.visit(filter, extraData);
    }

    protected boolean isSimpleFeature() {
        return this.featureType instanceof SimpleFeatureType;
    }

    public Object visit(Function function, Object extraData) {
        if (this.isVolatileFunction(function)) {
            return super.visit(function, extraData);
        }
        if (this.attributeExtractor == null) {
            this.attributeExtractor = new FilterAttributeExtractor();
        } else {
            this.attributeExtractor.clear();
        }
        function.accept((ExpressionVisitor)this.attributeExtractor, null);
        if (this.attributeExtractor.isConstantExpression()) {
            Object result = function.evaluate(null);
            return this.ff.literal(result);
        }
        return super.visit(function, extraData);
    }

    protected boolean isVolatileFunction(Function function) {
        return function instanceof VolatileFunction;
    }

    public static Filter simplify(Filter filter) {
        return OptimizedSimplifyingFilterVisitor.simplify(filter, null);
    }

    public static Filter simplify(Filter filter, FeatureType featureType) {
        if (filter == Filter.INCLUDE || filter == Filter.EXCLUDE || filter == null) {
            return filter;
        }
        OptimizedSimplifyingFilterVisitor visitor = new OptimizedSimplifyingFilterVisitor();
        visitor.setFeatureType(featureType);
        return (Filter)filter.accept((FilterVisitor)visitor, null);
    }

    protected boolean isConstant(Expression ex) {
        if (ex instanceof Literal) {
            return true;
        }
        if (ex instanceof NilExpression) {
            return true;
        }
        if (ex instanceof PropertyName) {
            return false;
        }
        this.attributeExtractor.clear();
        ex.accept((ExpressionVisitor)this.attributeExtractor, null);
        return this.attributeExtractor.isConstantExpression();
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        PropertyIsBetween clone = (PropertyIsBetween)super.visit(filter, extraData);
        if (this.isConstant(clone.getExpression()) && this.isConstant(clone.getLowerBoundary()) && this.isConstant(clone.getUpperBoundary())) {
            return this.staticFilterEvaluate((Filter)clone);
        }
        return clone;
    }

    private Object staticFilterEvaluate(Filter filter) {
        if (filter.evaluate(null)) {
            return Filter.INCLUDE;
        }
        return Filter.EXCLUDE;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    private Object simplifyBinaryComparisonOperator(BinaryComparisonOperator clone) {
        if (this.isConstant(clone.getExpression1()) && this.isConstant(clone.getExpression2())) {
            return this.staticFilterEvaluate((Filter)clone);
        }
        return clone;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.simplifyBinaryComparisonOperator((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        PropertyIsLike clone = (PropertyIsLike)super.visit(filter, extraData);
        if (this.isConstant(clone.getExpression())) {
            return this.staticFilterEvaluate((Filter)clone);
        }
        return clone;
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        PropertyIsNil clone = (PropertyIsNil)super.visit(filter, extraData);
        if (this.isConstant(clone.getExpression())) {
            return this.staticFilterEvaluate((Filter)clone);
        }
        return clone;
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        PropertyIsNull clone = (PropertyIsNull)super.visit(filter, extraData);
        if (this.isConstant(clone.getExpression())) {
            return this.staticFilterEvaluate((Filter)clone);
        }
        return clone;
    }
}

