/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.util;

import de.riwagis.crs.CRSDefFactory;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FilterUtil.class);
    private static final FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());

    private FilterUtil() {
    }

    @Deprecated
    public static Filter getEnvelopeFilter(Envelope env, FeatureCollection<SimpleFeatureType, SimpleFeature> fcol) throws Exception {
        SimpleFeatureType fType = (SimpleFeatureType)fcol.getSchema();
        return FilterUtil.getEnvelopeFilter(env, fType);
    }

    public static synchronized Filter getEnvelopeFilter(Envelope env, SimpleFeatureType fType) throws Exception {
        if (env == null || env.isNull()) {
            return Filter.INCLUDE;
        }
        if (fType.getGeometryDescriptor() == null) {
            return Filter.EXCLUDE;
        }
        String geometryPropertyName = fType.getGeometryDescriptor().getLocalName();
        ReferencedEnvelope bbox = new ReferencedEnvelope(fType.getGeometryDescriptor().getCoordinateReferenceSystem());
        bbox.expandToInclude(env);
        BBOX filter = filterFactory.bbox((Expression)filterFactory.property(geometryPropertyName), (BoundingBox)bbox);
        return filter;
    }

    public static synchronized Filter getEnvelopeFilter(Envelope env, String geomColumnName, int srid) throws Exception {
        ReferencedEnvelope bbox;
        if (env == null || env.isNull()) {
            return Filter.INCLUDE;
        }
        if (srid == -1) {
            bbox = new ReferencedEnvelope();
        } else {
            try {
                bbox = new ReferencedEnvelope(CRSDefFactory.createCRS("epsg:" + srid));
            }
            catch (NoSuchAuthorityCodeException nacEx) {
                LOG.warn(String.format("Invalid SRID '%d' at creating envelope filter. Returned filter with no srid specified", srid), (Throwable)nacEx);
                bbox = new ReferencedEnvelope();
            }
        }
        bbox.expandToInclude(env);
        BBOX filter = filterFactory.bbox((Expression)filterFactory.property(geomColumnName), (BoundingBox)bbox);
        return filter;
    }

    public static Filter getFidFilter(String fid) throws Exception {
        LinkedHashSet<FeatureId> setID = new LinkedHashSet<FeatureId>();
        setID.add(filterFactory.featureId(fid));
        return filterFactory.id(setID);
    }

    public static Filter getFidFilter(String[] fid) throws Exception {
        LinkedHashSet<FeatureId> setID = new LinkedHashSet<FeatureId>();
        for (String fid1 : fid) {
            setID.add(filterFactory.featureId(fid1));
        }
        return filterFactory.id(setID);
    }

    public static Filter buildFeatureIdFilter(String idCol, Object idVal) {
        if (idCol == null) {
            return filterFactory.id(new FeatureId[]{filterFactory.featureId(Objects.toString(idVal))});
        }
        return filterFactory.equals((Expression)filterFactory.property(idCol), (Expression)filterFactory.literal(idVal));
    }

    public static synchronized Filter getCQLFilter(String strCQL) throws Exception {
        return CQL.toFilter((String)strCQL, (FilterFactory)filterFactory);
    }

    public static Filter getAndFilter(Filter filter1, Filter filter2) throws Exception {
        if (filter1 == null || filter1 == Filter.INCLUDE) {
            return filter2;
        }
        if (filter2 == null || filter2 == Filter.INCLUDE) {
            return filter1;
        }
        return filterFactory.and(filter1, filter2);
    }
}

