/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.util;

import de.riwagis.util.jts.JTSSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.Types;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeatureUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureUtil.class);
    private static final GeometryFactory facGeom = new GeometryFactory();

    public static void closeQuietly(FeatureReader<?, ?> featureReader) {
        try {
            if (featureReader != null) {
                featureReader.close();
            }
        }
        catch (IOException ex) {
            LOG.debug(String.format("error closing feature reader '%s': %s", featureReader, ex.getMessage()), (Throwable)ex);
        }
    }

    private FeatureUtil() {
    }

    public static boolean isTypeValid(Class<?> target, Class<?> toCheck) {
        if (target == GeometryCollection.class) {
            return true;
        }
        if (target == Geometry.class) {
            return true;
        }
        if (target == Point.class) {
            return toCheck == Point.class;
        }
        if (target == LineString.class) {
            return toCheck == LineString.class;
        }
        if (target == Polygon.class) {
            return toCheck == Polygon.class;
        }
        if (target == MultiPoint.class) {
            return toCheck == Point.class || toCheck == MultiPoint.class;
        }
        if (target == MultiLineString.class) {
            if (toCheck == MultiLineString.class) {
                return true;
            }
            return toCheck == LineString.class;
        }
        if (target == MultiPolygon.class) {
            return toCheck == Polygon.class || toCheck == MultiPolygon.class;
        }
        return false;
    }

    public static AttributeDescriptor getAttributeDescriptor(SimpleFeatureType fType, String strAttName) {
        if (fType.getDescriptor(strAttName) != null) {
            return fType.getDescriptor(strAttName);
        }
        if (fType.getDescriptor(strAttName.toLowerCase()) != null) {
            return fType.getDescriptor(strAttName.toLowerCase());
        }
        return fType.getDescriptor(strAttName.toUpperCase());
    }

    public static boolean hasAttributeDescriptor(SimpleFeatureType fType, String strAttName) {
        return FeatureUtil.getAttributeDescriptor(fType, strAttName) != null;
    }

    public static boolean hasAttribute(SimpleFeature f, String strAttName) {
        return FeatureUtil.getAttributeDescriptor(f.getType(), strAttName) != null;
    }

    public static Object getAttribute(SimpleFeature f, String strAttName) {
        try {
            if (f.getAttribute(strAttName) != null) {
                return f.getAttribute(strAttName);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            if (f.getAttribute(strAttName.toLowerCase()) != null) {
                return f.getAttribute(strAttName.toLowerCase());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            return f.getAttribute(strAttName.toUpperCase());
        }
        catch (NullPointerException ne) {
            return null;
        }
    }

    public static boolean setAttribute(SimpleFeature f, String strAttName, Object objValue) {
        try {
            if (f.getFeatureType().getDescriptor(strAttName) != null) {
                f.setAttribute(strAttName, objValue);
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            if (f.getFeatureType().getDescriptor(strAttName.toLowerCase()) != null) {
                f.setAttribute(strAttName.toLowerCase(), objValue);
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            if (f.getFeatureType().getDescriptor(strAttName.toUpperCase()) != null) {
                f.setAttribute(strAttName.toUpperCase(), objValue);
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static SimpleFeatureType getEmptyFeatureType() {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName("EMPTY");
        return ftBuilder.buildFeatureType();
    }

    public static SimpleFeatureType getGeomFeatureType() throws SchemaException {
        return FeatureUtil.getGeomFeatureType(null);
    }

    public static SimpleFeatureType getGeomFeatureType(CoordinateReferenceSystem crs) throws SchemaException {
        SimpleFeatureTypeBuilder facGeomFeatType = new SimpleFeatureTypeBuilder();
        AttributeTypeBuilder atBuilder = new AttributeTypeBuilder();
        atBuilder = atBuilder.name("geom").binding(Geometry.class);
        if (crs != null) {
            atBuilder.crs(crs);
        }
        GeometryDescriptor attGeom = atBuilder.buildDescriptor("geom", atBuilder.buildGeometryType());
        facGeomFeatType.add((AttributeDescriptor)attGeom);
        facGeomFeatType.setName("wkt");
        return facGeomFeatType.buildFeatureType();
    }

    public static boolean isFeatureTypeEqual(SimpleFeatureType type1, SimpleFeatureType type2, boolean orderMatters) {
        if (!(type1 instanceof SimpleFeatureType) || !(type2 instanceof SimpleFeatureType)) {
            return false;
        }
        if (type1.getAttributeCount() != type2.getAttributeCount()) {
            return false;
        }
        for (int i = 0; i < type1.getAttributeCount(); ++i) {
            String attributeName = type1.getDescriptor(i).getLocalName();
            if (type2.getDescriptor(attributeName) == null) {
                return false;
            }
            if (orderMatters && !type2.getDescriptor(i).getLocalName().equals(attributeName)) {
                return false;
            }
            if (type1.getDescriptor(attributeName).getType().getBinding() == type2.getDescriptor(attributeName).getType().getBinding()) continue;
            return false;
        }
        return true;
    }

    public static SimpleFeature getEmptyFeature() {
        try {
            return SimpleFeatureBuilder.build((SimpleFeatureType)FeatureUtil.getEmptyFeatureType(), (Object[])new Object[0], (String)SimpleFeatureBuilder.createDefaultFeatureId());
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public static SimpleFeature getWKTFeature(String strWKT) {
        try {
            Geometry geom = new WKTReader().read(strWKT);
            SimpleFeatureType ftype = FeatureUtil.getGeomFeatureType();
            return SimpleFeatureBuilder.build((SimpleFeatureType)ftype, (Object[])new Object[]{geom}, (String)SimpleFeatureBuilder.createDefaultFeatureId());
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FeatureCollection<SimpleFeatureType, SimpleFeature> readWKTFeatureCollection(Reader reader) throws IOException {
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            WKTReader wktReader = new WKTReader();
            SimpleFeatureType ftype = FeatureUtil.getGeomFeatureType();
            ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
            try {
                while (!FeatureUtil.isAtEndOfFile(bufferedReader)) {
                    Geometry geom = wktReader.read((Reader)bufferedReader);
                    SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)ftype, (Object[])new Object[]{geom}, (String)SimpleFeatureBuilder.createDefaultFeatureId());
                    lstFeatures.add(feature);
                }
            }
            finally {
                ((Reader)bufferedReader).close();
            }
            SimpleFeatureCollection fcol = DataUtilities.collection(lstFeatures);
            return fcol;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static boolean isAtEndOfFile(Reader bufferedReader) throws IOException, ParseException {
        bufferedReader.mark(1000);
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(bufferedReader);
            int type = tokenizer.nextToken();
            if (type == -1) {
                boolean bl = true;
                return bl;
            }
            if (type == -3) {
                boolean bl = false;
                return bl;
            }
            throw new ParseException("Expected word or end-of-file but encountered StreamTokenizer type " + type);
        }
        finally {
            bufferedReader.reset();
        }
    }

    public static SimpleFeature getGeomFeature(Geometry geom) {
        try {
            SimpleFeatureType ftype = FeatureUtil.getGeomFeatureType();
            return SimpleFeatureBuilder.build((SimpleFeatureType)ftype, (Object[])new Object[]{geom}, (String)SimpleFeatureBuilder.createDefaultFeatureId());
        }
        catch (Exception e) {
            LOG.info("Error creating geometry feature.", (Throwable)e);
            Assert.shouldNeverReachHere((String)e.getMessage());
            return null;
        }
    }

    public static SimpleFeature createFeature(SimpleFeatureType fType) {
        return FeatureUtil.createFeature(fType, null, null);
    }

    public static SimpleFeature createFeature(SimpleFeatureType fType, Geometry geom) {
        return FeatureUtil.createFeature(fType, null, geom);
    }

    public static SimpleFeature createFeature(SimpleFeatureType fType, String newFid, Geometry geom) {
        try {
            if (newFid == null) {
                newFid = SimpleFeatureBuilder.createDefaultFeatureId();
            }
            SimpleFeatureBuilder fBuilder = new SimpleFeatureBuilder(fType);
            boolean geomDescriptorFound = false;
            for (AttributeDescriptor attDesc : fType.getAttributeDescriptors()) {
                if (attDesc instanceof GeometryDescriptor) {
                    GeometryDescriptor geomDesc = (GeometryDescriptor)attDesc;
                    geom = FeatureUtil.getGeometryOrEmptyGeometry(geom, geomDesc);
                    fBuilder.set(geomDesc.getName(), (Object)geom);
                    geomDescriptorFound = true;
                    continue;
                }
                if (attDesc.getDefaultValue() == null) continue;
                fBuilder.set(attDesc.getName(), attDesc.getDefaultValue());
            }
            if (!geomDescriptorFound && geom != null) {
                throw new IllegalArgumentException(String.format("No geometry column found in feature type %s.", fType.getName().getLocalPart()));
            }
            return fBuilder.buildFeature(newFid);
        }
        catch (Exception e) {
            LOG.info("Error creating feature.", (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            Assert.shouldNeverReachHere((String)e.getMessage());
            return null;
        }
    }

    private static Geometry getGeometryOrEmptyGeometry(Geometry geom, GeometryDescriptor gAttDesc) {
        if (geom != null) {
            return geom;
        }
        if (!gAttDesc.isNillable()) {
            return JTSSupport.createEmptyGeom((Class)gAttDesc.getType().getBinding());
        }
        return null;
    }

    public static SimpleFeature cloneFeature(SimpleFeature f) {
        return FeatureUtil.cloneFeature(f, false);
    }

    public static SimpleFeature cloneFeature(SimpleFeature f, boolean bolNewFID) {
        SimpleFeatureBuilder fBuilder = new SimpleFeatureBuilder(f.getFeatureType());
        fBuilder.init(f);
        SimpleFeature newFeat = bolNewFID ? fBuilder.buildFeature(SimpleFeatureBuilder.createDefaultFeatureId()) : fBuilder.buildFeature(f.getID());
        return newFeat;
    }

    public static GeometryCollection toGeometryCollection(Geometry geom) {
        if (geom instanceof GeometryCollection) {
            return (GeometryCollection)geom;
        }
        if (geom instanceof Point) {
            return new MultiPoint(new Point[]{(Point)geom}, facGeom);
        }
        if (geom instanceof LineString) {
            return new MultiLineString(new LineString[]{(LineString)geom}, facGeom);
        }
        if (geom instanceof Polygon) {
            return new MultiPolygon(new Polygon[]{(Polygon)geom}, facGeom);
        }
        return new GeometryCollection(new Geometry[]{geom}, facGeom);
    }

    public static void copyFeatureGeometry(SimpleFeature from, SimpleFeature to) throws IllegalAttributeException {
        for (int j = 0; j < from.getAttributeCount(); ++j) {
            AttributeDescriptor attTypeNew;
            AttributeDescriptor attType = from.getFeatureType().getDescriptor(j);
            String strName = attType.getLocalName();
            Object o = from.getAttribute(j);
            if (strName == null || (attTypeNew = to.getFeatureType().getDescriptor(strName)) == null || !(attType instanceof GeometryDescriptor)) continue;
            if (o == null) {
                to.setDefaultGeometry(null);
                continue;
            }
            Geometry geom = (Geometry)o;
            Class geomClass = attType.getType().getBinding();
            if (GeometryCollection.class.isAssignableFrom(geomClass)) {
                geom = FeatureUtil.toGeometryCollection(geom);
            }
            if (FeatureUtil.isTypeValid(geomClass, geom.getClass())) {
                to.setDefaultGeometry((Object)geom);
                continue;
            }
            throw new IllegalAttributeException(attType, (Object)geom, "The geometry type is not valid.");
        }
    }

    public static void copyFeatureData(SimpleFeature from, SimpleFeature to) throws IllegalAttributeException {
        for (int j = 0; j < from.getAttributeCount(); ++j) {
            AttributeDescriptor attType = from.getFeatureType().getDescriptor(j);
            String strName = attType.getLocalName();
            Object o = from.getAttribute(j);
            if (strName == null) continue;
            AttributeDescriptor attTypeNew = to.getFeatureType().getDescriptor(strName);
            if (attTypeNew == null) {
                strName = strName.toLowerCase();
                attTypeNew = to.getFeatureType().getDescriptor(strName);
            }
            if (attTypeNew == null) {
                strName = strName.toUpperCase();
                attTypeNew = to.getFeatureType().getDescriptor(strName);
            }
            if (attTypeNew == null) continue;
            if (attType instanceof GeometryDescriptor) {
                if (o == null) {
                    to.setDefaultGeometry(null);
                    continue;
                }
                Geometry geom = (Geometry)o;
                Class geomClass = attType.getType().getBinding();
                if (GeometryCollection.class.isAssignableFrom(geomClass)) {
                    geom = FeatureUtil.toGeometryCollection(geom);
                }
                if (FeatureUtil.isTypeValid(geomClass, geom.getClass())) {
                    to.setDefaultGeometry((Object)geom);
                    continue;
                }
                throw new IllegalAttributeException(attType, (Object)geom, "The geometry type is not valid.");
            }
            try {
                to.setAttribute(strName, Types.parse((AttributeDescriptor)attTypeNew, (Object)o));
                continue;
            }
            catch (Exception e) {
                LOG.warn("Warning: parse for atttype " + strName + " failed.", (Throwable)e);
            }
        }
    }

    public static String getFeatureIDWithoutTable(SimpleFeature f) {
        StringBuilder sbID = new StringBuilder(f.getID().toLowerCase());
        int intDot = sbID.indexOf(".");
        String strID = intDot > -1 ? sbID.substring(intDot + 1) : sbID.toString();
        return strID;
    }

    public static String getFeatureIDWithoutTable(String strID) {
        if (strID == null) {
            return null;
        }
        StringBuilder sbID = new StringBuilder(strID);
        int intDot = strID.indexOf(".");
        strID = intDot > -1 ? sbID.substring(intDot + 1) : sbID.toString();
        return strID;
    }

    public static void copyFeatureData(SimpleFeature from, SimpleFeature to, Map<String, String> attributesMap) throws IllegalAttributeException {
        for (int j = 0; j < from.getAttributeCount(); ++j) {
            AttributeDescriptor attType = from.getFeatureType().getDescriptor(j);
            String strNameOld = attType.getLocalName();
            String strNameTo = attType.getLocalName();
            if (attributesMap.containsKey(strNameOld)) {
                strNameTo = attributesMap.get(strNameOld);
            }
            Object o = from.getAttribute(j);
            if (strNameTo == null) continue;
            AttributeDescriptor attTypeNew = to.getFeatureType().getDescriptor(strNameTo);
            if (attTypeNew == null) {
                strNameTo = strNameTo.toLowerCase();
                attTypeNew = to.getFeatureType().getDescriptor(strNameTo);
            }
            if (attTypeNew == null) {
                strNameTo = strNameTo.toUpperCase();
                attTypeNew = to.getFeatureType().getDescriptor(strNameTo);
            }
            if (attTypeNew == null) continue;
            if (attType instanceof GeometryDescriptor) {
                if (o == null) {
                    to.setDefaultGeometry(null);
                    continue;
                }
                Geometry geom = (Geometry)o;
                Class geomClass = attType.getType().getBinding();
                if (GeometryCollection.class.isAssignableFrom(geomClass)) {
                    geom = FeatureUtil.toGeometryCollection(geom);
                }
                if (FeatureUtil.isTypeValid(geomClass, geom.getClass())) {
                    to.setDefaultGeometry((Object)geom);
                    continue;
                }
                throw new IllegalAttributeException(attType, (Object)geom, "The geometry type is not valid.");
            }
            try {
                to.setAttribute(strNameTo, Types.parse((AttributeDescriptor)attTypeNew, (Object)o));
                continue;
            }
            catch (Exception e) {
                LOG.warn("Warning: parse for atttype " + strNameOld + " failed.", (Throwable)e);
            }
        }
    }

    public static void copyFeatureData(SimpleFeature from, SimpleFeature to, String[] arrAtts) throws IllegalAttributeException {
        for (String arrAtt : arrAtts) {
            AttributeDescriptor attType = from.getFeatureType().getDescriptor(arrAtt);
            if (attType == null) continue;
            String strName = attType.getLocalName();
            Object o = from.getAttribute(arrAtt);
            if (strName == null) continue;
            AttributeDescriptor attTypeNew = to.getFeatureType().getDescriptor(strName);
            if (attTypeNew == null) {
                strName = strName.toLowerCase();
                attTypeNew = to.getFeatureType().getDescriptor(strName);
            }
            if (attTypeNew == null) {
                strName = strName.toUpperCase();
                attTypeNew = to.getFeatureType().getDescriptor(strName);
            }
            if (attTypeNew == null) continue;
            if (attType instanceof GeometryDescriptor) {
                if (o == null) {
                    to.setDefaultGeometry(null);
                    continue;
                }
                Geometry geom = (Geometry)o;
                Class geomClass = attType.getType().getBinding();
                if (GeometryCollection.class.isAssignableFrom(geomClass)) {
                    geom = FeatureUtil.toGeometryCollection(geom);
                }
                if (FeatureUtil.isTypeValid(geomClass, geom.getClass())) {
                    to.setDefaultGeometry((Object)geom);
                    continue;
                }
                throw new IllegalAttributeException(attType, (Object)geom, "The geometry type is not valid.");
            }
            to.setAttribute(strName, Types.parse((AttributeDescriptor)attTypeNew, (Object)o));
        }
    }

    public static boolean getBooleanAttribute(SimpleFeature f, String strAttName) {
        try {
            Object objValue = FeatureUtil.getAttribute(f, strAttName);
            if (objValue == null) {
                return false;
            }
            if (objValue instanceof Boolean) {
                return (Boolean)objValue;
            }
            if (objValue instanceof Number) {
                int numInt = ((Number)objValue).intValue();
                return numInt > 0;
            }
            return objValue.toString().equalsIgnoreCase("true");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Collection<Geometry> toGeometries(Collection<SimpleFeature> features) {
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        for (SimpleFeature feature : features) {
            if (feature.getDefaultGeometry() == null) continue;
            list.add((Geometry)feature.getDefaultGeometry());
        }
        return list;
    }
}

