/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.util;

import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class FeatureTypeUtil {
    public static boolean hasSchemaAttribute(SimpleFeatureType schema, String attr) {
        if (schema == null) {
            return false;
        }
        if (schema.indexOf(attr) != -1) {
            return true;
        }
        if (schema.indexOf(attr.toUpperCase()) != -1) {
            return true;
        }
        for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
            if (!ad.getLocalName().equalsIgnoreCase(attr)) continue;
            return true;
        }
        return false;
    }

    public static String getSchemaAttribute(SimpleFeatureType schema, String attr) {
        if (schema == null) {
            return null;
        }
        if (schema.indexOf(attr) != -1) {
            return attr;
        }
        if (schema.indexOf(attr.toUpperCase()) != -1) {
            return attr.toUpperCase();
        }
        if (schema.indexOf(attr.toLowerCase()) != -1) {
            return attr.toLowerCase();
        }
        for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
            if (!ad.getLocalName().equalsIgnoreCase(attr)) continue;
            return ad.getLocalName();
        }
        return null;
    }

    public static String getSchemaAttribute(boolean useUpperCase, String name) {
        if (useUpperCase) {
            return name.toUpperCase();
        }
        return name.toLowerCase();
    }

    public static boolean isSchemaNameInUpperCase(String datatypeName) {
        return datatypeName.equals(datatypeName.toUpperCase());
    }
}

