/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.util;

import de.riwagis.geotools.feature.util.OptimizedSimplifyingFilterVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class EnvelopeMergingFilterVisitor
extends OptimizedSimplifyingFilterVisitor {
    private final Map<String, BBOX> bBoxCache = new HashMap<String, BBOX>();

    @Override
    public Object visit(And filter, Object extraData) {
        Filter cloned;
        HashMap<String, BBOX> bBoxCacheInit = new HashMap<String, BBOX>(this.bBoxCache);
        ArrayList<Filter> newChildren = new ArrayList<Filter>(filter.getChildren().size());
        for (Filter child : filter.getChildren()) {
            if (!(child instanceof BBOX)) continue;
            cloned = (Filter)child.accept((FilterVisitor)this, extraData);
            BBOX bbCloned = (BBOX)cloned;
            this.addBBox2Cache(bbCloned, extraData);
        }
        for (Filter child : filter.getChildren()) {
            if (child instanceof BBOX) continue;
            if (child instanceof Or || child instanceof Not) {
                HashMap<String, BBOX> bBoxCacheTemp = new HashMap<String, BBOX>(this.bBoxCache);
                this.bBoxCache.clear();
                cloned = (Filter)child.accept((FilterVisitor)this, extraData);
                this.bBoxCache.putAll(bBoxCacheTemp);
            } else {
                cloned = (Filter)child.accept((FilterVisitor)this, extraData);
            }
            if (cloned == Filter.EXCLUDE) {
                return Filter.EXCLUDE;
            }
            if (cloned == Filter.INCLUDE) continue;
            newChildren.add(cloned);
        }
        HashMap<String, BBOX> bBox2Append = new HashMap<String, BBOX>(this.bBoxCache);
        for (String key2remove : bBoxCacheInit.keySet()) {
            bBox2Append.remove(key2remove);
        }
        for (String key2add : bBox2Append.keySet()) {
            newChildren.add((Filter)this.bBoxCache.remove(key2add));
        }
        if (newChildren.isEmpty()) {
            return Filter.INCLUDE;
        }
        if (newChildren.size() == 1) {
            return newChildren.get(0);
        }
        return this.getFactory(extraData).and(newChildren);
    }

    private void addBBox2Cache(BBOX bbox, Object extraData) {
        PropertyName propName = (PropertyName)bbox.getExpression1();
        CoordinateReferenceSystem crs = bbox.getBounds().getCoordinateReferenceSystem();
        String srs = CRS.toSRS((CoordinateReferenceSystem)crs);
        String key = propName.getPropertyName() + "$" + Objects.toString(srs, "");
        if (this.bBoxCache.containsKey(key)) {
            BBOX interBBox = this.bBoxCache.get(key);
            Envelope interBounds = this.getEnvFromBBOX(interBBox);
            Envelope bounds = this.getEnvFromBBOX(bbox);
            if (interBounds.isNull()) {
                interBounds.expandToInclude(bounds);
            } else {
                interBounds = interBounds.intersection(bounds);
            }
            BBOX bboxNew = this.getFactory(extraData).bbox((Expression)this.getFactory(extraData).property(propName.getPropertyName()), interBounds.getMinX(), interBounds.getMinY(), interBounds.getMaxX(), interBounds.getMaxY(), srs);
            this.bBoxCache.put(key, bboxNew);
        } else {
            this.bBoxCache.put(key, bbox);
        }
    }

    private Envelope getEnvFromBBOX(BBOX bbox) {
        BoundingBox bounds = bbox.getBounds();
        return new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
    }
}

