/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.typemapping;

import de.riwagis.geotools.feature.typemapping.DefaultValue;
import de.riwagis.geotools.feature.typemapping.FeatureTypeMapping;
import de.riwagis.geotools.feature.typemapping.TypeMap;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class TypeMappingFeatureIterator
implements FeatureIterator<SimpleFeature> {
    private FeatureIterator<SimpleFeature> delegate = null;
    private FeatureTypeMapping ftMapping = null;
    private String typeName = null;
    private List<TypeMap> attributeMapping = null;
    private List<DefaultValue> defaultValues = null;
    private FeatureTypeMapping.TypeMappingExceptionHandler exHander = null;
    private boolean returnFidWithTableNamePrefix = true;

    public TypeMappingFeatureIterator(String newTypeName, List<TypeMap> attributeMapping, List<DefaultValue> defaultValues, FeatureIterator<SimpleFeature> delegate, FeatureTypeMapping.TypeMappingExceptionHandler exHandler) {
        this.delegate = delegate;
        this.typeName = newTypeName;
        this.attributeMapping = attributeMapping;
        this.defaultValues = defaultValues;
        this.exHander = exHandler != null ? exHandler : FeatureTypeMapping.DEFAULT_EXCEPTION_HANDLER;
    }

    public boolean isReturnFidWithTableNamePrefix() {
        return this.returnFidWithTableNamePrefix;
    }

    public void setReturnFidWithTableNamePrefix(boolean returnFidWithTableNamePrefix) {
        this.returnFidWithTableNamePrefix = returnFidWithTableNamePrefix;
        if (this.ftMapping != null) {
            this.ftMapping.setReturnFidWithTableNamePrefix(returnFidWithTableNamePrefix);
        }
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public SimpleFeature next() throws NoSuchElementException {
        if (this.ftMapping == null) {
            if (this.delegate.hasNext()) {
                SimpleFeature f = (SimpleFeature)this.delegate.next();
                this.ftMapping = new FeatureTypeMapping(this.typeName, this.attributeMapping, this.defaultValues, f.getFeatureType(), this.exHander);
                this.ftMapping.setReturnFidWithTableNamePrefix(this.returnFidWithTableNamePrefix);
                return this.ftMapping.getMappedFeature(f);
            }
            return (SimpleFeature)this.delegate.next();
        }
        return this.ftMapping.getMappedFeature((SimpleFeature)this.delegate.next());
    }

    public void close() {
        this.delegate.close();
    }
}

