/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.typemapping;

import de.riwagis.geotools.feature.typemapping.DefaultValue;
import de.riwagis.geotools.feature.typemapping.TypeMap;
import de.riwagis.geotools.feature.util.FeatureUtil;
import java.util.List;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class FeatureTypeMapping {
    public static final TypeMappingExceptionHandler DEFAULT_EXCEPTION_HANDLER = new TypeMappingExceptionHandler(){

        @Override
        public void handleException(Class clazz, Throwable t) throws RuntimeException {
            throw new RuntimeException(t.getMessage(), t);
        }
    };
    private String typeName = null;
    private List<TypeMap> attributeMapping = null;
    private List<DefaultValue> defaultValues = null;
    private SimpleFeatureType mappedFeatureType = null;
    private SimpleFeatureType originalFeatureType = null;
    private TypeMappingExceptionHandler exHander = null;
    private boolean returnFidWithTableNamePrefix = true;

    public FeatureTypeMapping(String newTypeName, List<TypeMap> attributeMapping, List<DefaultValue> defaultValues, SimpleFeatureType originalFeatureType, TypeMappingExceptionHandler _exHandler) {
        this.typeName = newTypeName;
        this.attributeMapping = attributeMapping;
        this.defaultValues = defaultValues;
        this.originalFeatureType = originalFeatureType;
        this.mappedFeatureType = this.getMappedFeatureTypeInternal(originalFeatureType);
        this.exHander = _exHandler != null ? _exHandler : DEFAULT_EXCEPTION_HANDLER;
    }

    private SimpleFeatureType getMappedFeatureTypeInternal(SimpleFeatureType originalFeatureType) {
        SimpleFeatureTypeBuilder mappedFeatTypeBuilder = new SimpleFeatureTypeBuilder();
        mappedFeatTypeBuilder.setName(this.typeName);
        AttributeTypeBuilder attBuilder = new AttributeTypeBuilder();
        for (TypeMap typeMap : this.attributeMapping) {
            if (typeMap.getOldAttName().equalsIgnoreCase("PRIMARY_KEY")) {
                attBuilder.setName(typeMap.getNewAttName());
                if (typeMap.getBinding() == null) {
                    attBuilder.setBinding(String.class);
                } else {
                    attBuilder.setBinding(typeMap.getBinding());
                }
                attBuilder.setNillable(true);
                mappedFeatTypeBuilder.add(attBuilder.buildDescriptor(typeMap.getNewAttName(), attBuilder.buildType()));
                continue;
            }
            AttributeDescriptor attDesc = FeatureUtil.getAttributeDescriptor(originalFeatureType, typeMap.getOldAttName());
            if (attDesc == null) continue;
            attBuilder.setName(typeMap.getNewAttName());
            attBuilder.setNamespaceURI(attDesc.getName().getNamespaceURI());
            if (typeMap.getBinding() == null) {
                attBuilder.setBinding(attDesc.getType().getBinding());
            } else {
                attBuilder.setBinding(typeMap.getBinding());
            }
            attBuilder.setNillable(attDesc.isNillable());
            if (Geometry.class.isAssignableFrom(attDesc.getType().getBinding())) {
                mappedFeatTypeBuilder.add((AttributeDescriptor)attBuilder.buildDescriptor(typeMap.getNewAttName(), attBuilder.buildGeometryType()));
                mappedFeatTypeBuilder.setDefaultGeometry(typeMap.getNewAttName());
                continue;
            }
            mappedFeatTypeBuilder.add(attBuilder.buildDescriptor(typeMap.getNewAttName(), attBuilder.buildType()));
        }
        for (DefaultValue defValue : this.defaultValues) {
            attBuilder.setName(defValue.getNewAttName());
            attBuilder.setBinding(defValue.getBinding());
            attBuilder.setNillable(true);
            if (Geometry.class.isAssignableFrom(defValue.getBinding())) {
                mappedFeatTypeBuilder.add((AttributeDescriptor)attBuilder.buildDescriptor(defValue.getNewAttName(), attBuilder.buildGeometryType()));
                mappedFeatTypeBuilder.setDefaultGeometry(defValue.getNewAttName());
                continue;
            }
            mappedFeatTypeBuilder.add(attBuilder.buildDescriptor(defValue.getNewAttName(), attBuilder.buildType()));
        }
        return mappedFeatTypeBuilder.buildFeatureType();
    }

    public SimpleFeatureType getMappedFeatureType() {
        return this.mappedFeatureType;
    }

    public SimpleFeature getMappedFeature(SimpleFeature originalFeature) {
        Object[] arrValues = new Object[this.mappedFeatureType.getAttributeCount()];
        int i = 0;
        for (TypeMap typeMap : this.attributeMapping) {
            AttributeDescriptor attDesc = FeatureUtil.getAttributeDescriptor(this.originalFeatureType, typeMap.getOldAttName());
            if (attDesc == null && !typeMap.getOldAttName().equalsIgnoreCase("PRIMARY_KEY")) continue;
            arrValues[i] = typeMap.getOldAttName().equalsIgnoreCase("PRIMARY_KEY") ? FeatureUtil.getFeatureIDWithoutTable(originalFeature) : FeatureUtil.getAttribute(originalFeature, typeMap.getOldAttName());
            try {
                arrValues[i] = typeMap.convertValue(arrValues[i], this.mappedFeatureType.getDescriptor(typeMap.getNewAttName()));
            }
            catch (Throwable t) {
                arrValues[i] = null;
                this.exHander.handleException(typeMap.getClass(), t);
            }
            ++i;
        }
        for (DefaultValue defValue : this.defaultValues) {
            arrValues[i] = defValue.getDefaultValue();
            ++i;
        }
        String oldFid = FeatureUtil.getFeatureIDWithoutTable(originalFeature);
        Object newFid = this.returnFidWithTableNamePrefix ? this.typeName + "." + oldFid : oldFid;
        return SimpleFeatureBuilder.build((SimpleFeatureType)this.mappedFeatureType, (Object[])arrValues, (String)newFid);
    }

    public boolean isReturnFidWithTableNamePrefix() {
        return this.returnFidWithTableNamePrefix;
    }

    public void setReturnFidWithTableNamePrefix(boolean returnFidWithTableNamePrefix) {
        this.returnFidWithTableNamePrefix = returnFidWithTableNamePrefix;
    }

    public static interface TypeMappingExceptionHandler {
        public void handleException(Class var1, Throwable var2) throws RuntimeException;
    }
}

