/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.typemapping;

import de.riwagis.geotools.feature.typemapping.TypeMap;
import de.riwagis.util.DateSupport;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.geotools.feature.type.Types;
import org.opengis.feature.type.AttributeDescriptor;

public class DefaultTypeMap
implements TypeMap {
    private final String oldAttName;
    private final String newAttName;
    private final Class binding;
    private static final Format dateFormat = SimpleDateFormat.getDateInstance(3);

    public DefaultTypeMap(String oldAttName, String newAttName) {
        this(oldAttName, newAttName, null);
    }

    public DefaultTypeMap(String oldAttName, String newAttName, Class binding) {
        this.oldAttName = oldAttName;
        this.newAttName = newAttName;
        this.binding = binding;
    }

    @Override
    public String getOldAttName() {
        return this.oldAttName;
    }

    @Override
    public String getNewAttName() {
        return this.newAttName;
    }

    @Override
    public Class getBinding() {
        return this.binding;
    }

    @Override
    public Object convertValue(Object obj, AttributeDescriptor addDesc) {
        if (this.binding != null) {
            if (obj instanceof Date && this.binding.equals(String.class)) {
                return DateSupport.toString((Date)((Date)obj));
            }
            if (obj instanceof String && this.binding.equals(Date.class)) {
                return this.toDate(obj);
            }
            if (obj instanceof String && ObjectUtils.toString((Object)obj).length() == 0 && !this.binding.equals(String.class)) {
                return null;
            }
            return Types.parse((AttributeDescriptor)addDesc, (Object)obj);
        }
        return obj;
    }

    private Object toDate(Object obj) {
        if (obj == null) {
            return null;
        }
        String strTemp = obj.toString().trim();
        if (strTemp.length() == 0) {
            return null;
        }
        String[] arrDate = strTemp.split("\\.");
        if (arrDate.length == 1) {
            arrDate = strTemp.split("\\/");
        }
        if (arrDate.length == 1) {
            strTemp = String.format("1.7.%s", arrDate[0]);
        }
        if (arrDate.length == 2) {
            strTemp = String.format("1.%s.%s", arrDate[0], arrDate[1]);
        }
        if (arrDate.length == 3) {
            strTemp = String.format("%s.%s.%s", arrDate[0], arrDate[1], arrDate[2]);
        }
        try {
            return dateFormat.parseObject(strTemp);
        }
        catch (ParseException e) {
            return null;
        }
    }

    static {
        ((DateFormat)dateFormat).setLenient(true);
    }
}

