/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.bsh;

import bsh.EvalError;
import bsh.ParseException;
import bsh.TargetError;
import de.riwagis.geotools.feature.bsh.FeatBshCalculator;
import de.riwagis.geotools.feature.bsh.FeatBshStringBuilder;
import de.riwagis.geotools.feature.util.FeatureUtil;
import java.util.Date;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatBshValidator {
    private static final Logger LOG = LoggerFactory.getLogger(FeatBshValidator.class);
    private static final Geometry GEOMETRY_POINT_ZERO = JTSFactoryFinder.getGeometryFactory(null).createPoint(new Coordinate(0.0, 0.0));

    public static String validateTextExpression(String strBsh, SimpleFeatureType fSchema) {
        try {
            SimpleFeature feature = FeatureUtil.createFeature(fSchema);
            for (int i = 0; i < fSchema.getAttributeCount(); ++i) {
                String strName = fSchema.getDescriptor(i).getLocalName();
                if (fSchema.getDescriptor(i).getType().getBinding() == Double.class) {
                    feature.setAttribute(i, (Object)1.0);
                }
                if (fSchema.getDescriptor(i).getType().getBinding() == Integer.class) {
                    feature.setAttribute(i, (Object)1);
                }
                if (fSchema.getDescriptor(i).getType().getBinding() == Object.class) {
                    feature.setAttribute(i, (Object)strName);
                }
                if (fSchema.getDescriptor(i).getType().getBinding() == Geometry.class) {
                    feature.setAttribute(i, (Object)GEOMETRY_POINT_ZERO);
                }
                if (fSchema.getDescriptor(i).getType().getBinding() == String.class) {
                    feature.setAttribute(i, (Object)strName);
                }
                if (fSchema.getDescriptor(i).getType().getBinding() != Date.class) continue;
                feature.setAttribute(i, (Object)new Date());
            }
            FeatBshStringBuilder bsb = FeatBshStringBuilder.getInstance(strBsh);
            bsb.setRaiseErrorOnMissingAttributes(true);
            bsb.setFeature(feature);
            if (bsb.getString().equals("void")) {
                throw new Exception("Invalid BeanShell expression. Returned 'void'.");
            }
            return null;
        }
        catch (Exception e) {
            LOG.debug("Error validating TextExpression '{}': {}", (Object)strBsh, (Object)e.getMessage());
            return "Error:" + e.getMessage();
        }
    }

    public static String validateCalcExpression(String strBsh, SimpleFeatureType fSchema) {
        try {
            SimpleFeature feature = FeatureUtil.createFeature(fSchema);
            for (int i = 0; i < fSchema.getAttributeCount(); ++i) {
                String strName = fSchema.getDescriptor(i).getLocalName();
                if (fSchema.getDescriptor(i).getType().getBinding() == Double.class) {
                    feature.setAttribute(i, (Object)1.0);
                }
                if (fSchema.getDescriptor(i).getType().getBinding() != Integer.class) continue;
                feature.setAttribute(i, (Object)1);
            }
            FeatBshCalculator bsc = FeatBshCalculator.getInstance(strBsh);
            bsc.setRaiseErrorOnMissingAttributes(true);
            bsc.setFeature(feature);
            bsc.getDouble();
            return null;
        }
        catch (TargetError e) {
            return e.printTargetError(null);
        }
        catch (ParseException e) {
            return e.getMessage();
        }
        catch (EvalError e) {
            return e.getErrorText();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

