/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.bsh;

import bsh.Interpreter;
import de.riwagis.geotools.feature.bsh.AbstractFeatBshTool;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatBshStringBuilder
extends AbstractFeatBshTool {
    private static final Logger LOG = LoggerFactory.getLogger(FeatBshStringBuilder.class);
    private static final Lock lock = new ReentrantLock();

    public abstract String getString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FeatBshStringBuilder getInstance(String strBsh) throws Exception {
        long time = System.currentTimeMillis();
        try {
            String strValue;
            String strAttName;
            lock.lock();
            if (StringUtils.isBlank((CharSequence)strBsh)) {
                ConstantFeatBshStringBuilder constantFeatBshStringBuilder = new ConstantFeatBshStringBuilder("");
                return constantFeatBshStringBuilder;
            }
            String strBshTrimmed = StringUtils.trimToEmpty((String)strBsh);
            if (strBshTrimmed.startsWith("str(\"") && strBshTrimmed.endsWith("\")") && !(strAttName = strBshTrimmed.substring(5, strBshTrimmed.length() - 2)).contains("\"")) {
                AttributeFeatBshStringBuilder attributeFeatBshStringBuilder = new AttributeFeatBshStringBuilder(strAttName);
                return attributeFeatBshStringBuilder;
            }
            if (strBshTrimmed.startsWith("\"") && strBshTrimmed.endsWith("\"") && !(strValue = strBshTrimmed.substring(1, strBshTrimmed.length() - 1)).contains("\"")) {
                ConstantFeatBshStringBuilder constantFeatBshStringBuilder = new ConstantFeatBshStringBuilder(strValue);
                return constantFeatBshStringBuilder;
            }
            Interpreter ip = new Interpreter();
            Object obj = ip.eval("new de.riwagis.geotools.feature.bsh.FeatBshStringBuilder(){public String getString(){return Objects.toString(" + strBshTrimmed + ");}};");
            FeatBshStringBuilder featBshStringBuilder = (FeatBshStringBuilder)obj;
            return featBshStringBuilder;
        }
        finally {
            lock.unlock();
            long time2 = System.currentTimeMillis();
            LOG.trace("FeatBshStringBuilder created. Time: " + (time2 - time) + " : " + strBsh);
        }
    }

    private static class ConstantFeatBshStringBuilder
    extends FeatBshStringBuilder {
        private final String value;

        public ConstantFeatBshStringBuilder(String strValue) {
            this.value = strValue;
        }

        @Override
        public String getString() {
            return this.value;
        }
    }

    private static class AttributeFeatBshStringBuilder
    extends FeatBshStringBuilder {
        private final String attributeName;

        public AttributeFeatBshStringBuilder(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public String getString() {
            try {
                return this.str(this.attributeName);
            }
            catch (Exception e) {
                Assert.shouldNeverReachHere();
                return "";
            }
        }
    }
}

