/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.bsh;

import bsh.Interpreter;
import de.riwagis.geotools.feature.bsh.AbstractFeatBshTool;
import de.riwagis.geotools.feature.bsh.FeatBshStringBuilder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatBshObjectBuilder
extends AbstractFeatBshTool {
    private static final Logger LOG = LoggerFactory.getLogger(FeatBshStringBuilder.class);
    private static final Lock lock = new ReentrantLock();

    public abstract Object getObject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FeatBshObjectBuilder getInstance(String strBsh) throws Exception {
        long time = System.currentTimeMillis();
        try {
            String strValue;
            String strAttName;
            lock.lock();
            if (StringUtils.isBlank((CharSequence)strBsh)) {
                FeatBshObjectBuilder featBshObjectBuilder = new FeatBshObjectBuilder(){

                    @Override
                    public Object getObject() {
                        return "";
                    }
                };
                return featBshObjectBuilder;
            }
            String strBshTrimmed = StringUtils.trimToEmpty((String)strBsh);
            if (strBshTrimmed.startsWith("str(\"") && strBshTrimmed.endsWith("\")") && !(strAttName = strBshTrimmed.substring(5, strBshTrimmed.length() - 2)).contains("\"")) {
                FeatBshObjectBuilder featBshObjectBuilder = new FeatBshObjectBuilder(){

                    @Override
                    public Object getObject() {
                        try {
                            return this.str(strAttName);
                        }
                        catch (Exception e) {
                            Assert.shouldNeverReachHere();
                            return "";
                        }
                    }
                };
                return featBshObjectBuilder;
            }
            if (strBshTrimmed.startsWith("\"") && strBshTrimmed.endsWith("\"") && !(strValue = strBshTrimmed.substring(1, strBshTrimmed.length() - 1)).contains("\"")) {
                FeatBshObjectBuilder featBshObjectBuilder = new FeatBshObjectBuilder(){

                    @Override
                    public Object getObject() {
                        return strValue;
                    }
                };
                return featBshObjectBuilder;
            }
            if (strBshTrimmed.startsWith("num(\"") && strBshTrimmed.endsWith("\")") && !(strAttName = strBshTrimmed.substring(5, strBshTrimmed.length() - 2)).contains("\"")) {
                FeatBshObjectBuilder featBshObjectBuilder = new FeatBshObjectBuilder(){

                    @Override
                    public Object getObject() {
                        try {
                            return this.num(strAttName);
                        }
                        catch (Exception e) {
                            Assert.shouldNeverReachHere();
                            return 0.0;
                        }
                    }
                };
                return featBshObjectBuilder;
            }
            Interpreter ip = new Interpreter();
            Object obj = ip.eval("new de.riwagis.geotools.feature.bsh.FeatBshObjectBuilder(){public Object getObject(){return " + strBshTrimmed + ";}};");
            FeatBshObjectBuilder featBshObjectBuilder = (FeatBshObjectBuilder)obj;
            return featBshObjectBuilder;
        }
        finally {
            lock.unlock();
            long time2 = System.currentTimeMillis();
            LOG.trace("FeatBshObjectBuilder created. Time: " + (time2 - time) + " : " + strBsh);
        }
    }
}

