/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.bsh;

import bsh.Interpreter;
import de.riwagis.geotools.feature.bsh.AbstractFeatBshTool;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatBshCalculator
extends AbstractFeatBshTool {
    private static final Logger LOG = LoggerFactory.getLogger(FeatBshCalculator.class);
    private static final Lock lock = new ReentrantLock();

    public abstract double getDouble();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FeatBshCalculator getInstance(String strBsh) throws Exception {
        long time = System.currentTimeMillis();
        try {
            lock.lock();
            if (StringUtils.isBlank((CharSequence)strBsh)) {
                FeatBshCalculator featBshCalculator = new FeatBshCalculator(){

                    @Override
                    public double getDouble() {
                        return 0.0;
                    }
                };
                return featBshCalculator;
            }
            String strBshTrimmed = StringUtils.trimToEmpty((String)strBsh);
            try {
                final double dblValue = Double.parseDouble(strBshTrimmed);
                FeatBshCalculator featBshCalculator = new FeatBshCalculator(){

                    @Override
                    public double getDouble() {
                        return dblValue;
                    }
                };
                return featBshCalculator;
            }
            catch (Exception e) {
                block9: {
                    String strAttName;
                    LOG.trace(String.format("unable to parse '%s' as number: %s", strBshTrimmed, e.getMessage()), (Throwable)e);
                    if (!strBshTrimmed.startsWith("num(\"") || !strBshTrimmed.endsWith("\")") || (strAttName = strBshTrimmed.substring(5, strBshTrimmed.length() - 2)).contains("\"")) break block9;
                    FeatBshCalculator featBshCalculator = new FeatBshCalculator(){

                        @Override
                        public double getDouble() {
                            try {
                                return this.num(strAttName);
                            }
                            catch (Exception e) {
                                Assert.shouldNeverReachHere();
                                return 0.0;
                            }
                        }
                    };
                    lock.unlock();
                    long time2 = System.currentTimeMillis();
                    LOG.trace("FeatBshCalculator created. Time: " + (time2 - time) + " : " + strBsh);
                    return featBshCalculator;
                }
                Interpreter ip = new Interpreter();
                Object obj = ip.eval("new de.riwagis.geotools.feature.bsh.FeatBshCalculator(){public double getDouble(){return (double)" + strBshTrimmed + ";}};");
                FeatBshCalculator featBshCalculator = (FeatBshCalculator)obj;
                lock.unlock();
                long time2 = System.currentTimeMillis();
                LOG.trace("FeatBshCalculator created. Time: " + (time2 - time) + " : " + strBsh);
                return featBshCalculator;
            }
        }
        finally {
            lock.unlock();
            long time2 = System.currentTimeMillis();
            LOG.trace("FeatBshCalculator created. Time: " + (time2 - time) + " : " + strBsh);
        }
    }
}

