/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.bsh;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ColumnAliases {
    private final Map<String, String> aliases = new LinkedHashMap<String, String>();

    public void setAliases(ColumnAliases aliases) {
        this.aliases.clear();
        if (aliases != null) {
            this.aliases.putAll(aliases.internalMap());
        }
    }

    public String getAlias(String aliasName) {
        String cleanAliasname = this.cleanupAlias(aliasName);
        String columnNameAlias = this.aliases.get(cleanAliasname);
        return (String)StringUtils.defaultIfBlank((CharSequence)columnNameAlias, (CharSequence)aliasName);
    }

    private Map<String, String> internalMap() {
        return this.aliases;
    }

    public void addAlias(String aliasname, String columnName) {
        if (StringUtils.isBlank((CharSequence)columnName)) {
            throw new IllegalArgumentException(String.format("columnName for alias '%s' must not be empty", aliasname));
        }
        String cleanAliasname = this.cleanupAlias(aliasname);
        if (StringUtils.isNotBlank((CharSequence)cleanAliasname)) {
            this.aliases.put(cleanAliasname, columnName);
        }
    }

    private String cleanupAlias(String aliasName) {
        return StringUtils.trimToEmpty((String)aliasName);
    }
}

