/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.geotools.feature.bsh;

import de.riwagis.crs.CRSDefinition;
import de.riwagis.geotools.feature.bsh.ColumnAliases;
import de.riwagis.geotools.feature.bsh.MissingFieldException;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.unit.DrawingUnit;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeatBshTool {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFeatBshTool.class);
    private SimpleFeature f = null;
    private double dbldefault = 0.0;
    private String strDefault = "";
    private final NumberFormat nf;
    private boolean isProjectionReductionActive = true;
    private double heightReduction = 0.0;
    private DrawingUnit unit;
    private CRSDefinition crsDefinition;
    private final ColumnAliases aliases = new ColumnAliases();
    private boolean raiseErrorOnMissingAttributes = false;

    public void setAliases(ColumnAliases aliases) {
        this.aliases.setAliases(aliases);
    }

    public AbstractFeatBshTool() {
        this(Locale.GERMAN);
    }

    public AbstractFeatBshTool(Locale _nfLocale) {
        this.nf = NumberFormat.getInstance(_nfLocale);
    }

    public void setDefault(double _default) {
        this.dbldefault = _default;
    }

    public double getDefaultNum() {
        return this.dbldefault;
    }

    public void setDefault(String _default) {
        this.strDefault = _default;
    }

    public String getDefaultStr() {
        return this.strDefault;
    }

    public boolean isRaiseErrorOnMissingAttributes() {
        return this.raiseErrorOnMissingAttributes;
    }

    public void setRaiseErrorOnMissingAttributes(boolean raiseErrorOnMissingAttributes) {
        this.raiseErrorOnMissingAttributes = raiseErrorOnMissingAttributes;
    }

    public SimpleFeatureType getFeatureType() {
        return this.f == null ? null : this.f.getFeatureType();
    }

    public void setFeature(SimpleFeature _f) {
        this.f = _f;
    }

    public SimpleFeature getFeature() {
        return this.f;
    }

    public double area() {
        this.checkDefaultGeometry();
        if (this.f.getDefaultGeometry() != null) {
            Geometry geom = (Geometry)this.f.getDefaultGeometry();
            if (this.isProjectionReductionActive && this.crsDefinition != null) {
                return this.crsDefinition.getRealWorldArea(geom, this.heightReduction, this.unit);
            }
            return geom.getArea();
        }
        return this.dbldefault;
    }

    public String area(int digits) {
        this.nf.setMaximumFractionDigits(digits);
        this.nf.setMinimumFractionDigits(digits);
        return this.nf.format(this.area());
    }

    public double length() {
        this.checkDefaultGeometry();
        if (this.f.getDefaultGeometry() != null) {
            Geometry geom = (Geometry)this.f.getDefaultGeometry();
            if (this.isProjectionReductionActive && this.crsDefinition != null) {
                return this.crsDefinition.getRealWorldDistance(geom, this.heightReduction, this.unit);
            }
            return geom.getLength();
        }
        return this.dbldefault;
    }

    public String length(int digits) {
        this.nf.setMaximumFractionDigits(digits);
        this.nf.setMinimumFractionDigits(digits);
        return this.nf.format(this.length());
    }

    public void checkDefaultGeometry() {
        if (this.raiseErrorOnMissingAttributes && this.f.getDefaultGeometryProperty() == null) {
            throw new MissingFieldException("missing geometry attribute");
        }
    }

    public String date(String name) {
        return this.date(name, null);
    }

    public String date(String name, String dateFormatString) {
        Object obj = this.val(name);
        AttributeDescriptor desc = this.readAttributeDescriptor(name);
        String res = this.strDefault;
        java.util.Date zeDate = null;
        if (obj != null) {
            DateFormat df;
            DateFormat dateFormat = df = StringUtils.isBlank((CharSequence)dateFormatString) ? DateFormat.getDateInstance() : new SimpleDateFormat(dateFormatString);
            if (desc.getType().getBinding() == java.util.Date.class) {
                zeDate = (java.util.Date)obj;
            }
            if (desc.getType().getBinding() == Date.class) {
                zeDate = new java.util.Date(((java.util.Date)obj).getTime());
            }
            if (desc.getType().getBinding() == Timestamp.class) {
                zeDate = new java.util.Date(((java.util.Date)obj).getTime());
            }
            res = df.format(zeDate);
        }
        return res;
    }

    public AttributeDescriptor readAttributeDescriptor(String fieldname) {
        SimpleFeatureType fSchema = this.f.getFeatureType();
        AttributeDescriptor desc = FeatureUtil.getAttributeDescriptor(fSchema, fieldname);
        return desc;
    }

    public int integer(String name) {
        return (int)this.num(name);
    }

    public long lng(String name) {
        return (long)this.num(name);
    }

    public String fid() {
        return FeatureUtil.getFeatureIDWithoutTable(this.f.getID());
    }

    public double num(String name) {
        Object obj = this.val(name);
        return this.formatNum(obj);
    }

    public Object val(String fieldname) {
        String fieldnameAliased = this.aliases.getAlias(fieldname);
        this.checkAttribute(fieldnameAliased);
        return FeatureUtil.getAttribute(this.f, fieldnameAliased);
    }

    public String num(String name, int digits) {
        Object obj = this.val(name);
        return this.formatNum(obj, digits);
    }

    public double formatNum(Object obj) {
        try {
            return this.parseNumberObj(obj);
        }
        catch (ParseException nfex) {
            LOG.debug("ParseException", (Throwable)nfex);
            return this.dbldefault;
        }
    }

    protected double parseNumberObj(Object obj) throws ParseException {
        if (obj != null) {
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            if (obj instanceof String) {
                return this.nf.parse((String)obj).doubleValue();
            }
        }
        return this.dbldefault;
    }

    public String formatNum(Object obj, int digits) {
        if (obj != null) {
            try {
                double val = this.parseNumberObj(obj);
                this.nf.setMaximumFractionDigits(digits);
                this.nf.setMinimumFractionDigits(digits);
                return this.nf.format(val);
            }
            catch (ParseException nfex) {
                LOG.debug("ParseException", (Throwable)nfex);
                return obj.toString();
            }
        }
        return "";
    }

    public String str(String fieldname) {
        Object obj = this.val(fieldname);
        return obj == null ? this.strDefault : obj.toString();
    }

    public final void checkAttribute(String fieldname) throws MissingFieldException {
        SimpleFeatureType fSchema = this.getFeatureType();
        if (this.isRaiseErrorOnMissingAttributes() && !FeatureUtil.hasAttributeDescriptor(fSchema, fieldname)) {
            throw new MissingFieldException(String.format("missing attribute '%s'", fieldname));
        }
    }

    public void setProjectionReductionActive(boolean value) {
        this.isProjectionReductionActive = value;
    }

    public void setHeightReduction(double height) {
        this.heightReduction = height;
    }

    public void setDrawingUnit(DrawingUnit unit) {
        this.unit = unit;
    }

    public void setCRSDefintion(CRSDefinition crsDef) {
        this.crsDefinition = crsDef;
    }
}

